/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.el.FunctionMapper;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.dsp.DSPContext;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.ServletDSPContext;
import org.zkoss.web.servlet.dsp.impl.Parser;

public class Interpreter {
    public static final String getContentType(String path) {
        if (path == null) {
            return null;
        }
        int j = path.lastIndexOf(46);
        if (j < 0 || path.indexOf(47, j + 1) >= 0) {
            return null;
        }
        int k = path.indexOf(59, j + 1);
        String ext = (k >= 0 ? path.substring(j + 1, k) : path.substring(j + 1)).toLowerCase();
        if ("dsp".equals(ext)) {
            if (j == 0) {
                return null;
            }
            k = path.lastIndexOf(46, j - 1);
            if (k < 0) {
                return null;
            }
            ext = path.substring(k + 1, j);
            if (ext.indexOf(47) >= 0) {
                return null;
            }
        }
        return ContentTypes.getContentType((String)ext);
    }

    public final Interpretation parse(String content, String ctype, FunctionMapper fm, Locator loc) throws ServletException, IOException {
        return new Parser().parse(content, ctype, fm, loc);
    }

    public final void interpret(DSPContext dc, FunctionMapper fm, String content, String ctype) throws ServletException, IOException {
        this.parse(content, ctype, fm, dc.getLocator()).interpret(dc);
    }

    public final void interpret(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String content, String ctype, Locator locator) throws ServletException, IOException {
        this.interpret(new ServletDSPContext(ctx, request, response, locator), null, content, ctype);
    }
}

