/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.el;

import java.io.Writer;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.zkoss.el.EvaluatorImpl;
import org.zkoss.el.impl.AttributesMap;
import org.zkoss.el.impl.StringKeysMap;

public class RequestResolver
implements VariableResolver {
    private final ServletContext _ctx;
    private final ServletRequest _request;
    private final ServletResponse _response;
    private HttpSession _sess;
    private Map _reqScope;
    private Map _sessScope;
    private Map _appScope;
    private PageContextImpl _pc;
    private Map _cookies;

    public RequestResolver(ServletContext ctx, ServletRequest request, ServletResponse response) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        this._ctx = ctx;
        this._request = request;
        this._response = response;
    }

    public RequestResolver(ServletContext ctx, ServletRequest request) {
        this(ctx, request, null);
    }

    public RequestResolver(ServletRequest request) {
        this(null, request, null);
    }

    public PageContext getPageContext() {
        if (this._pc == null) {
            this._pc = new PageContextImpl();
        }
        return this._pc;
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public Object resolveVariable(String name) throws ELException {
        if ("pageContext".equals(name)) {
            return this.getPageContext();
        }
        if ("pageScope".equals(name)) {
            return Collections.EMPTY_MAP;
        }
        if ("requestScope".equals(name)) {
            return this.getRequestScope();
        }
        if ("sessionScope".equals(name)) {
            return this.getSessionScope();
        }
        if ("applicationScope".equals(name)) {
            return this.getApplicationScope();
        }
        if ("param".equals(name)) {
            return new ParamMap();
        }
        if ("paramValues".equals(name)) {
            return this._request.getParameterMap();
        }
        if ("header".equals(name)) {
            if (!(this._request instanceof HttpServletRequest)) {
                return Collections.EMPTY_MAP;
            }
            final HttpServletRequest hreq = (HttpServletRequest)this._request;
            return new AttributesMap(){

                protected Enumeration getKeys() {
                    return hreq.getHeaderNames();
                }

                protected Object getValue(String key) {
                    return hreq.getHeader(key);
                }
            };
        }
        if ("headerValues".equals(name)) {
            if (!(this._request instanceof HttpServletRequest)) {
                return Collections.EMPTY_MAP;
            }
            final HttpServletRequest hreq = (HttpServletRequest)this._request;
            return new AttributesMap(){
                private final Map _values = new HashMap();

                protected Enumeration getKeys() {
                    return hreq.getHeaderNames();
                }

                protected Object getValue(String key) {
                    Object o = this._values.get(key);
                    if (o == null) {
                        Enumeration e = hreq.getHeaders(key);
                        if (e == null || !e.hasMoreElements()) {
                            return null;
                        }
                        LinkedList l = new LinkedList();
                        do {
                            l.add(e.nextElement());
                        } while (e.hasMoreElements());
                        o = l.toArray(new String[l.size()]);
                        this._values.put(key, o);
                    }
                    return o;
                }
            };
        }
        if ("initParam".equals(name)) {
            if (this._ctx == null) {
                return Collections.EMPTY_MAP;
            }
            return new AttributesMap(){

                protected Enumeration getKeys() {
                    return RequestResolver.this._ctx.getInitParameterNames();
                }

                protected Object getValue(String key) {
                    return RequestResolver.this._ctx.getInitParameter(key);
                }
            };
        }
        if ("cookie".equals(name)) {
            Cookie[] cookies;
            if (this._cookies != null) {
                return this._cookies;
            }
            if (!(this._request instanceof HttpServletRequest) || (cookies = ((HttpServletRequest)this._request).getCookies()) == null || cookies.length == 0) {
                return Collections.EMPTY_MAP;
            }
            this._cookies = new HashMap();
            int j = cookies.length;
            while (--j >= 0) {
                this._cookies.put(cookies[j].getName(), cookies[j]);
            }
        }
        return this.findAttribute(name);
    }

    private HttpSession getSession() {
        if (this._sess != null) {
            return this._sess;
        }
        if (!(this._request instanceof HttpServletRequest)) {
            return null;
        }
        this._sess = ((HttpServletRequest)this._request).getSession(false);
        return this._sess;
    }

    private Object findAttribute(String name) {
        Object o = this.getRequestScope().get(name);
        if (o != null) {
            return o;
        }
        o = this.getSessionScope().get(name);
        return o != null ? o : this.getApplicationScope().get(name);
    }

    private Map getRequestScope() {
        if (this._reqScope != null) {
            return this._reqScope;
        }
        this._reqScope = new AttributesMap(){

            protected Enumeration getKeys() {
                return RequestResolver.this._request.getAttributeNames();
            }

            protected Object getValue(String key) {
                return RequestResolver.this._request.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                RequestResolver.this._request.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                RequestResolver.this._request.removeAttribute(key);
            }
        };
        return this._reqScope;
    }

    private Map getSessionScope() {
        if (this._sessScope != null) {
            return this._sessScope;
        }
        final HttpSession sess = this.getSession();
        if (sess == null) {
            this._sessScope = Collections.EMPTY_MAP;
            return this._sessScope;
        }
        this._sessScope = new AttributesMap(){

            protected Enumeration getKeys() {
                return sess.getAttributeNames();
            }

            protected Object getValue(String key) {
                return sess.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                sess.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                sess.removeAttribute(key);
            }
        };
        return this._sessScope;
    }

    private Map getApplicationScope() {
        if (this._appScope != null) {
            return this._appScope;
        }
        if (this._ctx == null) {
            this._appScope = Collections.EMPTY_MAP;
            return this._appScope;
        }
        this._appScope = new AttributesMap(){

            protected Enumeration getKeys() {
                return RequestResolver.this._ctx.getAttributeNames();
            }

            protected Object getValue(String key) {
                return RequestResolver.this._ctx.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                RequestResolver.this._ctx.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                RequestResolver.this._ctx.removeAttribute(key);
            }
        };
        return this._appScope;
    }

    private class PageContextImpl
    extends PageContext {
        private PageContextImpl() {
        }

        public Exception getException() {
            return null;
        }

        public Object getPage() {
            return null;
        }

        public ServletRequest getRequest() {
            return RequestResolver.this._request;
        }

        public ServletResponse getResponse() {
            return RequestResolver.this._response;
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public ServletContext getServletContext() {
            return RequestResolver.this._ctx;
        }

        public HttpSession getSession() {
            return RequestResolver.this.getSession();
        }

        public VariableResolver getVariableResolver() {
            return RequestResolver.this;
        }

        public ExpressionEvaluator getExpressionEvaluator() {
            return new EvaluatorImpl();
        }

        public void forward(String relativeUrlPath) {
            throw new UnsupportedOperationException();
        }

        public void include(String relativeUrlPath) {
            throw new UnsupportedOperationException();
        }

        public void include(String relativeUrlPath, boolean flush) {
            throw new UnsupportedOperationException();
        }

        public void handlePageException(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void handlePageException(Throwable e) {
            throw new UnsupportedOperationException();
        }

        public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        }

        public BodyContent pushBody() {
            throw new UnsupportedOperationException();
        }

        public void release() {
        }

        public Object findAttribute(String name) {
            return RequestResolver.this.findAttribute(name);
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Object getAttribute(String name, int scope) {
            switch (scope) {
                case 2: {
                    return RequestResolver.this.getRequestScope().get(name);
                }
                case 3: {
                    return RequestResolver.this.getSessionScope().get(name);
                }
                case 4: {
                    return RequestResolver.this.getSessionScope().get(name);
                }
            }
            return null;
        }

        public Enumeration getAttributeNamesInScope(int scope) {
            throw new UnsupportedOperationException();
        }

        public int getAttributesScope(String name) {
            throw new UnsupportedOperationException();
        }

        public JspWriter getOut() {
            throw new UnsupportedOperationException();
        }

        public JspWriter popBody() {
            throw new UnsupportedOperationException();
        }

        public JspWriter pushBody(Writer writer) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String name) {
        }

        public void removeAttribute(String name, int scope) {
            switch (scope) {
                case 2: {
                    RequestResolver.this.getRequestScope().remove(name);
                    return;
                }
                case 3: {
                    RequestResolver.this.getSessionScope().remove(name);
                    return;
                }
                case 4: {
                    RequestResolver.this.getSessionScope().remove(name);
                    return;
                }
            }
        }

        public void setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String name, Object value, int scope) {
            if (value == null) {
                this.removeAttribute(name, scope);
                return;
            }
            switch (scope) {
                case 2: {
                    RequestResolver.this.getRequestScope().put(name, value);
                    return;
                }
                case 3: {
                    RequestResolver.this.getSessionScope().put(name, value);
                    return;
                }
                case 4: {
                    RequestResolver.this.getSessionScope().put(name, value);
                    return;
                }
            }
        }
    }

    private class ParamMap
    extends StringKeysMap {
        private Set _entries;

        private ParamMap() {
        }

        public Set entrySet() {
            if (this._entries == null) {
                this._entries = new AbstractSet(){

                    public int size() {
                        return ParamMap.this.size();
                    }

                    public boolean contains(Object o) {
                        return ParamMap.this.containsKey(o);
                    }

                    public Iterator iterator() {
                        return new StringKeysMap.EntryIter(ParamMap.this);
                    }
                };
            }
            return this._entries;
        }

        public int size() {
            return RequestResolver.this._request.getParameterMap().size();
        }

        public boolean containsKey(Object key) {
            return RequestResolver.this._request.getParameterMap().containsKey(key);
        }

        protected Object getValue(String key) {
            return RequestResolver.this._request.getParameter(key);
        }

        protected Enumeration getKeys() {
            return RequestResolver.this._request.getParameterNames();
        }
    }
}

