/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.togglz.core.Togglz;
import org.togglz.core.bootstrap.FeatureManagerBootstrapper;
import org.togglz.core.context.ContextClassLoaderFeatureManagerProvider;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.spi.FeatureManagerListener;
import org.togglz.core.util.Services;
import org.togglz.servlet.CompositeRequestListener;
import org.togglz.servlet.TogglzFilterConfig;
import org.togglz.servlet.spi.RequestListener;

public class TogglzFilter
implements Filter {
    public static final String EXECUTED = TogglzFilter.class.getName() + ".done";
    private final Logger log = LoggerFactory.getLogger(TogglzFilter.class);
    private FeatureManager bootstrappedFeatureManager;
    private CompositeRequestListener requestListener;

    public void init(FilterConfig filterConfig) {
        TogglzFilterConfig config = new TogglzFilterConfig(filterConfig.getServletContext());
        this.requestListener = new CompositeRequestListener(Services.getSorted(RequestListener.class));
        Boolean bootstrap = config.isPerformBootstrap();
        if (bootstrap == null) {
            FeatureManager existingFeatureManager = FeatureContext.getFeatureManagerOrNull();
            if (existingFeatureManager == null) {
                this.log.debug("Could not find any existing FeatureManager");
                bootstrap = true;
            } else {
                this.log.debug("Found existing FeatureManager: " + existingFeatureManager.getName());
                bootstrap = false;
            }
        }
        if (bootstrap.booleanValue()) {
            this.log.debug("Starting FeatureManager bootstrap process");
            FeatureManagerBootstrapper boostrapper = new FeatureManagerBootstrapper();
            this.bootstrappedFeatureManager = boostrapper.createFeatureManager((Object)filterConfig.getServletContext());
            for (FeatureManagerListener listener : Services.getSorted(FeatureManagerListener.class)) {
                listener.start(this.bootstrappedFeatureManager);
            }
            ContextClassLoaderFeatureManagerProvider.bind((FeatureManager)this.bootstrappedFeatureManager);
            this.log.debug("FeatureManager has been created: " + this.bootstrappedFeatureManager.getName());
        }
        this.log.info(Togglz.getNameWithVersion() + " started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (Boolean.TRUE.equals(req.getAttribute(EXECUTED))) {
            chain.doFilter(req, resp);
        } else {
            req.setAttribute(EXECUTED, (Object)Boolean.TRUE);
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            try {
                this.requestListener.begin(request, response);
                chain.doFilter(req, resp);
            }
            finally {
                this.requestListener.end(request, response);
            }
        }
    }

    public void destroy() {
        if (this.bootstrappedFeatureManager != null) {
            for (FeatureManagerListener listener : Services.getSorted(FeatureManagerListener.class)) {
                listener.stop(this.bootstrappedFeatureManager);
            }
            ContextClassLoaderFeatureManagerProvider.release();
        }
    }
}

