/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ForwardedHeaderUtils {
    private static final String FORWARDED_VALUE = "\"?([^;,\"]+)\"?";
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("(?i:host)=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("(?i:proto)=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("(?i:for)=\"?([^;,\"]+)\"?");

    public static UriComponentsBuilder adaptFromForwardedHeaders(URI uri, HttpHeaders headers) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri(uri);
        try {
            String forwardedHeader = headers.getFirst("Forwarded");
            if (StringUtils.hasText((String)forwardedHeader)) {
                Matcher matcher = FORWARDED_PROTO_PATTERN.matcher(forwardedHeader);
                if (matcher.find()) {
                    uriComponentsBuilder.scheme(matcher.group(1).trim());
                    uriComponentsBuilder.port(null);
                } else if (ForwardedHeaderUtils.isForwardedSslOn(headers)) {
                    uriComponentsBuilder.scheme("https");
                    uriComponentsBuilder.port(null);
                }
                matcher = FORWARDED_HOST_PATTERN.matcher(forwardedHeader);
                if (matcher.find()) {
                    ForwardedHeaderUtils.adaptForwardedHost(uriComponentsBuilder, matcher.group(1).trim());
                }
            } else {
                String portHeader;
                String protocolHeader = headers.getFirst("X-Forwarded-Proto");
                if (StringUtils.hasText((String)protocolHeader)) {
                    uriComponentsBuilder.scheme(StringUtils.tokenizeToStringArray((String)protocolHeader, (String)",")[0]);
                    uriComponentsBuilder.port(null);
                } else if (ForwardedHeaderUtils.isForwardedSslOn(headers)) {
                    uriComponentsBuilder.scheme("https");
                    uriComponentsBuilder.port(null);
                }
                String hostHeader = headers.getFirst("X-Forwarded-Host");
                if (StringUtils.hasText((String)hostHeader)) {
                    ForwardedHeaderUtils.adaptForwardedHost(uriComponentsBuilder, StringUtils.tokenizeToStringArray((String)hostHeader, (String)",")[0]);
                }
                if (StringUtils.hasText((String)(portHeader = headers.getFirst("X-Forwarded-Port")))) {
                    uriComponentsBuilder.port(Integer.parseInt(StringUtils.tokenizeToStringArray((String)portHeader, (String)",")[0]));
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Failed to parse a port from \"forwarded\"-type headers. If not behind a trusted proxy, consider using ForwardedHeaderFilter with removeOnly=true. Request headers: " + String.valueOf(headers));
        }
        uriComponentsBuilder.resetPortIfDefaultForScheme();
        return uriComponentsBuilder;
    }

    private static boolean isForwardedSslOn(HttpHeaders headers) {
        String forwardedSsl = headers.getFirst("X-Forwarded-Ssl");
        return StringUtils.hasText((String)forwardedSsl) && forwardedSsl.equalsIgnoreCase("on");
    }

    private static void adaptForwardedHost(UriComponentsBuilder uriComponentsBuilder, String rawValue) {
        int squareBracketIdx;
        int portSeparatorIdx = rawValue.lastIndexOf(58);
        if (portSeparatorIdx > (squareBracketIdx = rawValue.lastIndexOf(93))) {
            if (squareBracketIdx == -1 && rawValue.indexOf(58) != portSeparatorIdx) {
                throw new IllegalArgumentException("Invalid IPv4 address: " + rawValue);
            }
            uriComponentsBuilder.host(rawValue.substring(0, portSeparatorIdx));
            uriComponentsBuilder.port(Integer.parseInt(rawValue, portSeparatorIdx + 1, rawValue.length(), 10));
        } else {
            uriComponentsBuilder.host(rawValue);
            uriComponentsBuilder.port(null);
        }
    }

    public static @Nullable InetSocketAddress parseForwardedFor(URI uri, HttpHeaders headers, @Nullable InetSocketAddress remoteAddress) {
        String forwardedToUse;
        Matcher matcher;
        int port = remoteAddress != null ? remoteAddress.getPort() : ("https".equals(uri.getScheme()) ? 443 : 80);
        String forwardedHeader = headers.getFirst("Forwarded");
        if (StringUtils.hasText((String)forwardedHeader) && (matcher = FORWARDED_FOR_PATTERN.matcher(forwardedToUse = StringUtils.tokenizeToStringArray((String)forwardedHeader, (String)",")[0])).find()) {
            int squareBracketIdx;
            String value;
            String host = value = matcher.group(1).trim();
            int portSeparatorIdx = value.lastIndexOf(58);
            if (portSeparatorIdx > (squareBracketIdx = value.lastIndexOf(93))) {
                if (squareBracketIdx == -1 && value.indexOf(58) != portSeparatorIdx) {
                    throw new IllegalArgumentException("Invalid IPv4 address: " + value);
                }
                host = value.substring(0, portSeparatorIdx);
                try {
                    port = Integer.parseInt(value, portSeparatorIdx + 1, value.length(), 10);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Failed to parse a port from \"forwarded\"-type header value: " + value);
                }
            }
            return InetSocketAddress.createUnresolved(host, port);
        }
        String forHeader = headers.getFirst("X-Forwarded-For");
        if (StringUtils.hasText((String)forHeader)) {
            String host = StringUtils.tokenizeToStringArray((String)forHeader, (String)",")[0];
            boolean ipv6 = host.indexOf(58) != -1;
            host = ipv6 && !host.startsWith("[") && !host.endsWith("]") ? "[" + host + "]" : host;
            return InetSocketAddress.createUnresolved(host, port);
        }
        return null;
    }
}

