/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.streams;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.springframework.expression.Expression;

public class HeaderEnricherProcessor<K, V>
extends ContextualProcessor<K, V, K, V> {
    private final Map<String, Expression> headerExpressions = new HashMap<String, Expression>();

    public HeaderEnricherProcessor(Map<String, Expression> headerExpressions) {
        this.headerExpressions.putAll(headerExpressions);
    }

    public void process(Record<K, V> record) {
        Headers headers = record.headers();
        Container<Object, Object> container = new Container<Object, Object>(this.context(), record.key(), record.value(), record);
        this.headerExpressions.forEach((name, expression) -> {
            Object headerValue = expression.getValue((Object)container);
            if (headerValue instanceof String) {
                headerValue = ((String)headerValue).getBytes(StandardCharsets.UTF_8);
            } else if (!(headerValue instanceof byte[])) {
                throw new IllegalStateException("Invalid header value type: " + String.valueOf(headerValue.getClass()));
            }
            headers.add((Header)new RecordHeader(name, (byte[])headerValue));
        });
        this.context().forward(record);
    }

    public void close() {
    }

    public static final class Container<K, V> {
        private final ProcessorContext<K, V> context;
        private final K key;
        private final V value;
        private final Record<K, V> record;

        Container(ProcessorContext<K, V> context, K key, V value, Record<K, V> record) {
            this.context = context;
            this.key = key;
            this.value = value;
            this.record = record;
        }

        public ProcessorContext<K, V> getContext() {
            return this.context;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Record<K, V> getRecord() {
            return this.record;
        }
    }
}

