/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json.converter.support;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.geode.data.json.converter.ObjectToJsonConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class JacksonObjectToJsonConverter
implements ObjectToJsonConverter {
    protected static final String AT_TYPE_METADATA_PROPERTY_NAME = "@type";

    @NonNull
    public String convert(@NonNull Object source) {
        Assert.notNull((Object)source, (String)"Source object to convert must not be null");
        try {
            return this.convertObjectToJson(source);
        }
        catch (JsonProcessingException cause) {
            throw new ConversionFailedException(TypeDescriptor.forObject((Object)source), TypeDescriptor.valueOf(String.class), source, (Throwable)cause);
        }
    }

    @NonNull
    protected String convertObjectToJson(@NonNull Object source) throws JsonProcessingException {
        Assert.notNull((Object)source, (String)"Source object to convert must not be null");
        return this.newObjectMapper(source).writeValueAsString(source);
    }

    @NonNull
    protected ObjectMapper newObjectMapper(@NonNull Object target) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        return this.newObjectMapper().addMixIn(target.getClass(), ObjectTypeMetadataMixin.class).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.INDENT_OUTPUT, true).findAndRegisterModules();
    }

    @NonNull
    ObjectMapper newObjectMapper() {
        return new ObjectMapper();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@type")
    static interface ObjectTypeMetadataMixin {
    }
}

