/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json.converter.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.geode.pdx.PdxInstance;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.data.json.converter.JsonToPdxArrayConverter;
import org.springframework.geode.data.json.converter.JsonToPdxConverter;
import org.springframework.geode.data.json.converter.support.JSONFormatterJsonToPdxConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class JacksonJsonToPdxConverter
implements JsonToPdxArrayConverter {
    private JsonToPdxConverter converter = this.newJsonToPdxConverter();
    private ObjectMapper objectMapper = this.newObjectMapper();

    @NonNull
    private <T> Iterable<T> asIterable(@NonNull Iterator<T> iterator) {
        return () -> iterator;
    }

    private JsonToPdxConverter newJsonToPdxConverter() {
        return new JSONFormatterJsonToPdxConverter();
    }

    private ObjectMapper newObjectMapper() {
        return new ObjectMapper();
    }

    @NonNull
    protected JsonToPdxConverter getJsonToPdxConverter() {
        return this.converter;
    }

    @NonNull
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Nullable
    public PdxInstance[] convert(String json) {
        try {
            JsonNode jsonNode = this.getObjectMapper().readTree(json);
            ArrayList<Object> pdxList = new ArrayList<Object>();
            if (this.isArray(jsonNode)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                JsonToPdxConverter converter = this.getJsonToPdxConverter();
                for (JsonNode object : this.asIterable(CollectionUtils.nullSafeIterator((Iterator)arrayNode.elements()))) {
                    pdxList.add(converter.convert(object.toString()));
                }
            } else if (this.isObject(jsonNode)) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                pdxList.add(this.getJsonToPdxConverter().convert(objectNode.toString()));
            } else {
                String message = String.format("Unable to process JSON node of type [%s]; expected either an [%s] or an [%s]", jsonNode.getNodeType(), JsonNodeType.OBJECT, JsonNodeType.ARRAY);
                throw new IllegalStateException(message);
            }
            return pdxList.toArray(new PdxInstance[0]);
        }
        catch (JsonProcessingException cause) {
            throw new DataRetrievalFailureException("Failed to read JSON content", (Throwable)cause);
        }
    }

    private boolean isArray(@Nullable JsonNode node) {
        return node != null && (node.isArray() || JsonNodeType.ARRAY.equals((Object)node.getNodeType()));
    }

    private boolean isObject(@Nullable JsonNode node) {
        return node != null && (node.isObject() || JsonNodeType.OBJECT.equals((Object)node.getNodeType()));
    }
}

