/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json.converter;

import java.util.Map;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.data.json.converter.ObjectArrayToJsonConverter;
import org.springframework.geode.data.json.converter.ObjectToJsonConverter;
import org.springframework.geode.data.json.converter.support.JSONFormatterPdxToJsonConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractObjectArrayToJsonConverter
implements ObjectArrayToJsonConverter {
    protected static final String BEGIN_ARRAY = "[";
    protected static final String EMPTY_STRING = "";
    protected static final String END_ARRAY = "]";
    protected static final String JSON_OBJECT_SEPARATOR = ", ";
    private ObjectToJsonConverter converter = this.newObjectToJsonConverter();

    @NonNull
    private ObjectToJsonConverter newObjectToJsonConverter() {
        return new JSONFormatterPdxToJsonConverter();
    }

    @NonNull
    protected ObjectToJsonConverter getObjectToJsonConverter() {
        return this.converter;
    }

    @NonNull
    public String convert(@NonNull Iterable<?> iterable) {
        Assert.notNull(iterable, (String)"Iterable must not be null");
        StringBuilder json = new StringBuilder(BEGIN_ARRAY);
        ObjectToJsonConverter converter = this.getObjectToJsonConverter();
        boolean addComma = false;
        for (Object value : CollectionUtils.nullSafeIterable(iterable)) {
            json.append(addComma ? JSON_OBJECT_SEPARATOR : EMPTY_STRING);
            json.append((String)converter.convert(value));
            addComma = true;
        }
        json.append(END_ARRAY);
        return json.toString();
    }

    @NonNull
    public <K, V> String convert(@Nullable Map<K, V> map) {
        return this.convert(CollectionUtils.nullSafeMap(map).values());
    }
}

