/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.geode.core.io.ResourceReadException;
import org.springframework.geode.core.io.ResourceReader;
import org.springframework.geode.core.io.UnhandledResourceException;
import org.springframework.geode.core.io.support.ResourceUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class AbstractResourceReader
implements ResourceReader {
    @Override
    @NonNull
    public byte[] read(@NonNull Resource resource) {
        return Optional.ofNullable(resource).filter(this::isAbleToHandle).map(this::preProcess).map(it -> {
            try (InputStream in = it.getInputStream();){
                byte[] byArray = this.doRead(in);
                return byArray;
            }
            catch (IOException cause) {
                throw new ResourceReadException(String.format("Failed to read from Resource [%s]", it.getDescription()), cause);
            }
        }).orElseThrow(() -> new UnhandledResourceException(String.format("Unable to handle Resource [%s]", ResourceUtils.nullSafeGetDescription(resource))));
    }

    protected boolean isAbleToHandle(@Nullable Resource resource) {
        return resource != null;
    }

    @NonNull
    protected abstract byte[] doRead(@NonNull InputStream var1) throws IOException;

    @NonNull
    protected Resource preProcess(@NonNull Resource resource) {
        return resource;
    }
}

