/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.env.support;

import java.util.Arrays;
import java.util.Optional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class User
implements Comparable<User> {
    private Role role;
    private final String name;
    private String password;

    public static User with(String name) {
        return new User(name);
    }

    private User(String name) {
        Assert.hasText((String)name, (String)String.format("User name [%s] is required", name));
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password).filter(StringUtils::hasText);
    }

    public Optional<Role> getRole() {
        return Optional.ofNullable(this.role);
    }

    public User withPassword(String password) {
        this.password = password;
        return this;
    }

    public User withRole(Role role) {
        this.role = role;
        return this;
    }

    @Override
    public int compareTo(User other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getName());
        return hashValue;
    }

    public String toString() {
        return this.getName();
    }

    public static enum Role {
        CLUSTER_OPERATOR,
        DEVELOPER;


        public static Role of(String name) {
            return Arrays.stream(Role.values()).filter(role -> role.name().equalsIgnoreCase(String.valueOf(name).trim())).findFirst().orElse(null);
        }

        public boolean isClusterOperator() {
            return CLUSTER_OPERATOR.equals((Object)this);
        }

        public boolean isDeveloper() {
            return DEVELOPER.equals((Object)this);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

