/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.geode.config.annotation.UseMemberName;
import org.springframework.util.StringUtils;

@Configuration
public class MemberNameConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private static final String GEMFIRE_NAME_PROPERTY = "name";
    private static final String SPRING_APPLICATION_NAME_PROPERTY = "spring.application.name";
    private static final String SPRING_DATA_GEMFIRE_CACHE_NAME_PROPERTY = "spring.data.gemfire.cache.name";
    private static final String SPRING_DATA_GEMFIRE_NAME_PROPERTY = "spring.data.gemfire.name";
    private static final String SPRING_DATA_GEODE_CACHE_NAME_PROPERTY = "spring.data.geode.cache.name";
    private static final String SPRING_DATA_GEODE_NAME_PROPERTY = "spring.data.geode.name";
    private static final Set<String> NAME_PROPERTIES = new HashSet<String>();
    private String memberName;

    protected Class<? extends Annotation> getAnnotationType() {
        return UseMemberName.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes memberNameAttributes = this.getAnnotationAttributes(importMetadata);
            this.setMemberName(memberNameAttributes.containsKey((Object)"value") ? memberNameAttributes.getString("value") : null);
            this.setMemberName(memberNameAttributes.containsKey((Object)GEMFIRE_NAME_PROPERTY) ? memberNameAttributes.getString(GEMFIRE_NAME_PROPERTY) : null);
        }
    }

    protected void setMemberName(String memberName) {
        this.memberName = Optional.ofNullable(memberName).filter(StringUtils::hasText).orElse(this.memberName);
    }

    protected Optional<String> getMemberName() {
        return Optional.ofNullable(this.memberName).filter(StringUtils::hasText);
    }

    @Bean
    @Order(value=-2147483648)
    ClientCacheConfigurer clientCacheMemberNameConfigurer(Environment environment) {
        return (beanName, clientCacheFactoryBean) -> this.configureMemberName(environment, (CacheFactoryBean)clientCacheFactoryBean);
    }

    @Bean
    @Order(value=-2147483648)
    PeerCacheConfigurer peerCacheMemberNameConfigurer(Environment environment) {
        return (beanName, peerCacheFactoryBean) -> this.configureMemberName(environment, (CacheFactoryBean)peerCacheFactoryBean);
    }

    private void configureMemberName(Environment environment, CacheFactoryBean cacheFactoryBean) {
        this.getMemberName().filter(memberName -> this.namePropertiesNotPresent(environment)).ifPresent(memberName -> cacheFactoryBean.getProperties().setProperty(GEMFIRE_NAME_PROPERTY, (String)memberName));
    }

    private boolean namePropertiesArePresent(Environment environment) {
        return NAME_PROPERTIES.stream().anyMatch(arg_0 -> ((Environment)environment).containsProperty(arg_0));
    }

    private boolean namePropertiesNotPresent(Environment environment) {
        return !this.namePropertiesArePresent(environment);
    }

    static {
        NAME_PROPERTIES.add(SPRING_APPLICATION_NAME_PROPERTY);
        NAME_PROPERTIES.add(SPRING_DATA_GEMFIRE_CACHE_NAME_PROPERTY);
        NAME_PROPERTIES.add(SPRING_DATA_GEMFIRE_NAME_PROPERTY);
        NAME_PROPERTIES.add(SPRING_DATA_GEODE_CACHE_NAME_PROPERTY);
        NAME_PROPERTIES.add(SPRING_DATA_GEODE_NAME_PROPERTY);
    }
}

