/*
 * Copyright 2019-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.rest.webmvc.config;

import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;

/**
 * SPI to be able to register extensions that add static resource routes. See
 * {@code org.springframework.data.rest.webmvc.halexplorer.HalExplorerConfiguration} in the HAL Explorer module.
 *
 * @author Oliver Drotbohm
 * @since 3.2
 */
public interface StaticResourceProvider {

	/**
	 * Customize the given {@link ResourceHandlerRegistry}.
	 *
	 * @param registry must not be {@literal null}.
	 * @param configuration must not be {@literal null}.
	 */
	void customizeResources(ResourceHandlerRegistry registry, RepositoryRestConfiguration configuration);
}
