/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.support;

import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.util.StringUtils;

public class MergingPersistenceUnitManager
extends DefaultPersistenceUnitManager {
    private static final Log LOG = LogFactory.getLog(MergingPersistenceUnitManager.class);

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        MutablePersistenceUnitInfo oldPui;
        super.postProcessPersistenceUnitInfo(pui);
        if (StringUtils.hasText((String)pui.getPersistenceUnitName()) && (oldPui = this.getPersistenceUnitInfo(pui.getPersistenceUnitName())) != null) {
            this.postProcessPersistenceUnitInfo(pui, oldPui);
        }
    }

    protected boolean isPersistenceUnitOverrideAllowed() {
        return true;
    }

    void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui, MutablePersistenceUnitInfo oldPui) {
        String persistenceUnitName = pui.getPersistenceUnitName();
        for (URL url : oldPui.getJarFileUrls()) {
            if (pui.getJarFileUrls().contains(url)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding JAR file URL %s to persistence unit %s", url, persistenceUnitName));
            }
            pui.addJarFileUrl(url);
        }
        for (String className : oldPui.getManagedClassNames()) {
            if (pui.getManagedClassNames().contains(className)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding class %s to PersistenceUnit %s", className, persistenceUnitName));
            }
            pui.addManagedClassName(className);
        }
        for (String mappingFileName : oldPui.getMappingFileNames()) {
            if (pui.getMappingFileNames().contains(mappingFileName)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding mapping file %s to persistence unit %s", mappingFileName, persistenceUnitName));
            }
            pui.addMappingFileName(mappingFileName);
        }
        URL newUrl = pui.getPersistenceUnitRootUrl();
        URL oldUrl = oldPui.getPersistenceUnitRootUrl();
        if (oldUrl == null || newUrl == null) {
            return;
        }
        try {
            boolean urlNotInJarUrls;
            boolean rootUrlsDiffer = !newUrl.toURI().equals(oldUrl.toURI());
            boolean bl = urlNotInJarUrls = !pui.getJarFileUrls().contains(oldUrl);
            if (rootUrlsDiffer && urlNotInJarUrls) {
                pui.addJarFileUrl(oldUrl);
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

