/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.EqlBaseVisitor;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class EqlQueryRenderer
extends EqlBaseVisitor<QueryTokenStream> {
    EqlQueryRenderer() {
    }

    @Override
    public QueryTokenStream visitStart(EqlParser.StartContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public QueryTokenStream visitQl_statement(EqlParser.Ql_statementContext ctx) {
        if (ctx.select_statement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.select_statement());
        }
        if (ctx.update_statement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.update_statement());
        }
        if (ctx.delete_statement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.delete_statement());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSelect_statement(EqlParser.Select_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        if (ctx.orderby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.orderby_clause()));
        }
        if (ctx.set_fuction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.set_fuction()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_statement(EqlParser.Update_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.update_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDelete_statement(EqlParser.Delete_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.delete_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFrom_clause(EqlParser.From_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable_declaration()));
        if (!ctx.identificationVariableDeclarationOrCollectionMemberDeclaration().isEmpty()) {
            builder.append(QueryTokens.TOKEN_COMMA);
        }
        builder.appendExpression(QueryTokenStream.concat(ctx.identificationVariableDeclarationOrCollectionMemberDeclaration(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitIdentificationVariableDeclarationOrCollectionMemberDeclaration(EqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx) {
        if (ctx.identification_variable_declaration() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable_declaration());
        }
        if (ctx.collection_member_declaration() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collection_member_declaration());
        }
        if (ctx.subquery() != null) {
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.append(QueryTokens.TOKEN_OPEN_PAREN);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendExpression(nested);
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            return builder;
        }
        return QueryRenderer.builder();
    }

    @Override
    public QueryTokenStream visitIdentification_variable_declaration(EqlParser.Identification_variable_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.range_variable_declaration()));
        builder.appendExpression(QueryTokenStream.concat(ctx.join(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        builder.appendExpression(QueryTokenStream.concat(ctx.fetch_join(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        return builder;
    }

    @Override
    public QueryTokenStream visitRange_variable_declaration(EqlParser.Range_variable_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.entity_name() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        } else if (ctx.function_invocation() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        }
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin(EqlParser.JoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_spec()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_association_path_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        if (ctx.join_condition() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_condition()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFetch_join(EqlParser.Fetch_joinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_spec()));
        builder.append(QueryTokens.expression(ctx.FETCH()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_association_path_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        if (ctx.join_condition() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_condition()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_spec(EqlParser.Join_specContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LEFT() != null) {
            builder.append(QueryTokens.expression(ctx.LEFT()));
        }
        if (ctx.OUTER() != null) {
            builder.append(QueryTokens.expression(ctx.OUTER()));
        }
        if (ctx.INNER() != null) {
            builder.append(QueryTokens.expression(ctx.INNER()));
        }
        if (ctx.JOIN() != null) {
            builder.append(QueryTokens.expression(ctx.JOIN()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_condition(EqlParser.Join_conditionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ON()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_association_path_expression(EqlParser.Join_association_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.TREAT() == null) {
            if (ctx.join_collection_valued_path_expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
            } else if (ctx.join_single_valued_path_expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
            }
        } else {
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            if (ctx.join_collection_valued_path_expression() != null) {
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
                nested.append(QueryTokens.expression(ctx.AS()));
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            } else if (ctx.join_single_valued_path_expression() != null) {
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
                nested.append(QueryTokens.expression(ctx.AS()));
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            }
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(nested);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_collection_valued_path_expression(EqlParser.Join_collection_valued_path_expressionContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(2 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        items.add(ctx.collection_valued_field());
        return QueryTokenStream.concat(items, arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitJoin_single_valued_path_expression(EqlParser.Join_single_valued_path_expressionContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(2 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        items.add(ctx.single_valued_object_field());
        return QueryTokenStream.concat(items, arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitCollection_member_declaration(EqlParser.Collection_member_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.IN()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        return builder;
    }

    @Override
    public QueryTokenStream visitQualified_identification_variable(EqlParser.Qualified_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.map_field_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.map_field_identification_variable()));
        } else if (ctx.identification_variable() != null) {
            builder.append(QueryTokens.expression(ctx.ENTRY()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMap_field_identification_variable(EqlParser.Map_field_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.KEY() != null) {
            builder.append(QueryTokens.token(ctx.KEY()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.VALUE() != null) {
            builder.append(QueryTokens.token(ctx.VALUE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSingle_valued_path_expression(EqlParser.Single_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.qualified_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.qualified_identification_variable()));
        } else if (ctx.qualified_identification_variable() != null) {
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.qualified_identification_variable()));
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.state_field_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneral_identification_variable(EqlParser.General_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        } else if (ctx.map_field_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.map_field_identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneral_subpath(EqlParser.General_subpathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simple_subpath() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simple_subpath()));
        } else if (ctx.treated_subpath() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.treated_subpath()));
            builder.appendInline(QueryTokenStream.concat(ctx.single_valued_object_field(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_subpath(EqlParser.Simple_subpathContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(1 + ctx.single_valued_object_field().size());
        items.add(ctx.general_identification_variable());
        items.addAll(ctx.single_valued_object_field());
        return QueryTokenStream.concat(items, arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitTreated_subpath(EqlParser.Treated_subpathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
        builder.append(QueryTokens.token(ctx.TREAT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitState_field_path_expression(EqlParser.State_field_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitState_valued_path_expression(EqlParser.State_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_field_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.general_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSingle_valued_object_path_expression(EqlParser.Single_valued_object_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollection_valued_path_expression(EqlParser.Collection_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_value_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_clause(EqlParser.Update_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UPDATE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        builder.append(QueryTokens.expression(ctx.SET()));
        builder.appendExpression(QueryTokenStream.concat(ctx.update_item(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_item(EqlParser.Update_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(3 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        if (ctx.state_field() != null) {
            items.add(ctx.state_field());
        } else if (ctx.single_valued_object_field() != null) {
            items.add(ctx.single_valued_object_field());
        }
        builder.appendInline(QueryTokenStream.concat(items, arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        builder.append(QueryTokens.TOKEN_EQUALS);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.new_value()));
        return builder;
    }

    @Override
    public QueryTokenStream visitNew_value(EqlParser.New_valueContext ctx) {
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.simple_entity_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_entity_expression());
        }
        if (ctx.NULL() != null) {
            return QueryTokenStream.ofToken(ctx.NULL());
        }
        return QueryRenderer.builder();
    }

    @Override
    public QueryTokenStream visitDelete_clause(EqlParser.Delete_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DELETE()));
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(EqlParser.Select_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.appendExpression(QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_item(EqlParser.Select_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.result_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.result_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_expression(EqlParser.Select_expressionContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.aggregate_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression());
        }
        if (ctx.identification_variable() != null) {
            if (ctx.OBJECT() == null) {
                return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
            }
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append(QueryTokens.token(ctx.OBJECT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            return builder;
        }
        if (ctx.constructor_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.constructor_expression());
        }
        return QueryRenderer.builder();
    }

    @Override
    public QueryTokenStream visitConstructor_expression(EqlParser.Constructor_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NEW()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.constructor_name()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.constructor_item(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitConstructor_item(EqlParser.Constructor_itemContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.aggregate_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression());
        }
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitAggregate_expression(EqlParser.Aggregate_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.AVG() != null || ctx.MAX() != null || ctx.MIN() != null || ctx.SUM() != null) {
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                builder.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.COUNT() != null) {
            builder.append(QueryTokens.token(ctx.COUNT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                builder.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            if (ctx.identification_variable() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            } else if (ctx.state_valued_path_expression() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
            } else if (ctx.single_valued_object_path_expression() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWhere_clause(EqlParser.Where_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHERE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupby_clause(EqlParser.Groupby_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.groupby_item(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupby_item(EqlParser.Groupby_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.single_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        } else if (ctx.scalar_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitHaving_clause(EqlParser.Having_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.HAVING()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderby_clause(EqlParser.Orderby_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ORDER()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.orderby_item(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderby_item(EqlParser.Orderby_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_field_path_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.general_identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.result_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.result_variable()));
        } else if (ctx.string_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        } else if (ctx.scalar_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        }
        if (ctx.ASC() != null) {
            builder.append(QueryTokens.expression(ctx.ASC()));
        }
        if (ctx.DESC() != null) {
            builder.append(QueryTokens.expression(ctx.DESC()));
        }
        if (ctx.nullsPrecedence() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitNullsPrecedence(EqlParser.NullsPrecedenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NULLS()));
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.expression(ctx.FIRST()));
        } else if (ctx.LAST() != null) {
            builder.append(QueryTokens.expression(ctx.LAST()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSet_fuction(EqlParser.Set_fuctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.setOperator() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.setOperator()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_statement()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSetOperator(EqlParser.SetOperatorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.INTERSECT() != null) {
            builder.append(QueryTokens.expression(ctx.INTERSECT()));
        } else if (ctx.UNION() != null) {
            builder.append(QueryTokens.expression(ctx.UNION()));
        } else if (ctx.EXCEPT() != null) {
            builder.append(QueryTokens.expression(ctx.EXCEPT()));
        } else if (ctx.ALL() != null) {
            builder.append(QueryTokens.expression(ctx.ALL()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery(EqlParser.SubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.simple_select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subquery_from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery_from_clause(EqlParser.Subquery_from_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression(QueryTokenStream.concat(ctx.subselect_identification_variable_declaration(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSubselect_identification_variable_declaration(EqlParser.Subselect_identification_variable_declarationContext ctx) {
        return (QueryTokenStream)super.visitSubselect_identification_variable_declaration(ctx);
    }

    @Override
    public QueryTokenStream visitDerived_path_expression(EqlParser.Derived_path_expressionContext ctx) {
        return (QueryTokenStream)super.visitDerived_path_expression(ctx);
    }

    @Override
    public QueryTokenStream visitGeneral_derived_path(EqlParser.General_derived_pathContext ctx) {
        return (QueryTokenStream)super.visitGeneral_derived_path(ctx);
    }

    @Override
    public QueryTokenStream visitSimple_derived_path(EqlParser.Simple_derived_pathContext ctx) {
        return (QueryTokenStream)super.visitSimple_derived_path(ctx);
    }

    @Override
    public QueryTokenStream visitTreated_derived_path(EqlParser.Treated_derived_pathContext ctx) {
        return (QueryTokenStream)super.visitTreated_derived_path(ctx);
    }

    @Override
    public QueryTokenStream visitDerived_collection_member_declaration(EqlParser.Derived_collection_member_declarationContext ctx) {
        return (QueryTokenStream)super.visitDerived_collection_member_declaration(ctx);
    }

    @Override
    public QueryTokenStream visitSimple_select_clause(EqlParser.Simple_select_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simple_select_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_select_expression(EqlParser.Simple_select_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.single_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.scalar_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitScalar_expression(EqlParser.Scalar_expressionContext ctx) {
        if (ctx.arithmetic_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression());
        }
        if (ctx.string_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.string_expression());
        }
        if (ctx.enum_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.enum_expression());
        }
        if (ctx.datetime_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression());
        }
        if (ctx.boolean_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression());
        }
        if (ctx.case_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.case_expression());
        }
        if (ctx.entity_type_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entity_type_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitConditional_expression(EqlParser.Conditional_expressionContext ctx) {
        if (ctx.conditional_expression() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
            builder.append(QueryTokens.expression(ctx.OR()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_term()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_term());
    }

    @Override
    public QueryTokenStream visitConditional_term(EqlParser.Conditional_termContext ctx) {
        if (ctx.conditional_term() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_term()));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_factor()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_factor());
    }

    @Override
    public QueryTokenStream visitConditional_factor(EqlParser.Conditional_factorContext ctx) {
        if (ctx.NOT() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append(QueryTokens.expression(ctx.NOT()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_primary()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_primary());
    }

    @Override
    public QueryTokenStream visitConditional_primary(EqlParser.Conditional_primaryContext ctx) {
        if (ctx.simple_cond_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_cond_expression());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.conditional_expression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_cond_expression(EqlParser.Simple_cond_expressionContext ctx) {
        if (ctx.comparison_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.comparison_expression());
        }
        if (ctx.between_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.between_expression());
        }
        if (ctx.in_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.in_expression());
        }
        if (ctx.like_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.like_expression());
        }
        if (ctx.null_comparison_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.null_comparison_expression());
        }
        if (ctx.empty_collection_comparison_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.empty_collection_comparison_expression());
        }
        if (ctx.collection_member_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collection_member_expression());
        }
        if (ctx.exists_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.exists_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBetween_expression(EqlParser.Between_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.arithmetic_expression(0) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(2)));
        } else if (ctx.string_expression(0) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(2)));
        } else if (ctx.datetime_expression(0) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(0)));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(1)));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(2)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIn_expression(EqlParser.In_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.string_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        }
        if (ctx.type_discriminator() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator()));
        }
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.IN() != null) {
            builder.append(QueryTokens.expression(ctx.IN()));
        }
        if (ctx.in_item() != null && !ctx.in_item().isEmpty()) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.in_item(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.collection_valued_input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_input_parameter()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIn_item(EqlParser.In_itemContext ctx) {
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        if (ctx.string_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.string_expression());
        }
        if (ctx.boolean_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_literal());
        }
        if (ctx.numeric_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.numeric_literal());
        }
        if (ctx.date_time_timestamp_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.date_time_timestamp_literal());
        }
        if (ctx.single_valued_input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_input_parameter());
        }
        if (ctx.conditional_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitLike_expression(EqlParser.Like_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.LIKE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.pattern_value()));
        if (ctx.ESCAPE() != null) {
            builder.append(QueryTokens.expression(ctx.ESCAPE()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.escape_character()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitNull_comparison_expression(EqlParser.Null_comparison_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.single_valued_path_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.nullif_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nullif_expression()));
        }
        if (ctx.op != null) {
            builder.append(QueryTokens.expression(ctx.op.getText()));
        } else {
            builder.append(QueryTokens.expression(ctx.IS()));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
        }
        builder.append(QueryTokens.expression(ctx.NULL()));
        return builder;
    }

    @Override
    public QueryTokenStream visitEmpty_collection_comparison_expression(EqlParser.Empty_collection_comparison_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.EMPTY()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollection_member_expression(EqlParser.Collection_member_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_or_value_expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.MEMBER()));
        if (ctx.OF() != null) {
            builder.append(QueryTokens.expression(ctx.OF()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntity_or_value_expression(EqlParser.Entity_or_value_expressionContext ctx) {
        if (ctx.single_valued_object_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression());
        }
        if (ctx.state_field_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression());
        }
        if (ctx.simple_entity_or_value_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_entity_or_value_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimple_entity_or_value_expression(EqlParser.Simple_entity_or_value_expressionContext ctx) {
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitExists_expression(EqlParser.Exists_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.EXISTS()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAll_or_any_expression(EqlParser.All_or_any_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.ALL() != null) {
            builder.append(QueryTokens.expression(ctx.ALL()));
        } else if (ctx.ANY() != null) {
            builder.append(QueryTokens.expression(ctx.ANY()));
        } else if (ctx.SOME() != null) {
            builder.append(QueryTokens.expression(ctx.SOME()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitStringComparison(EqlParser.StringComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.string_expression(1) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitBooleanComparison(EqlParser.BooleanComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        if (ctx.boolean_expression(1) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression(1)));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDirectBooleanCheck(EqlParser.DirectBooleanCheckContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression());
    }

    @Override
    public QueryTokenStream visitEnumComparison(EqlParser.EnumComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.enum_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        if (ctx.enum_expression(1) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.enum_expression(1)));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetimeComparison(EqlParser.DatetimeComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(0)));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.datetime_expression(1) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(1)));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityComparison(EqlParser.EntityComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_expression(0)));
        builder.append(QueryTokens.expression(ctx.op));
        if (ctx.entity_expression(1) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_expression(1)));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmeticComparison(EqlParser.ArithmeticComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.arithmetic_expression(1) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityTypeComparison(EqlParser.EntityTypeComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.entity_type_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_type_expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitRegexpComparison(EqlParser.RegexpComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        builder.append(QueryTokens.expression(ctx.REGEXP()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_literal()));
        return builder;
    }

    @Override
    public QueryTokenStream visitComparison_operator(EqlParser.Comparison_operatorContext ctx) {
        return QueryTokenStream.from(QueryTokens.ventilated(ctx.op));
    }

    @Override
    public QueryTokenStream visitArithmetic_expression(EqlParser.Arithmetic_expressionContext ctx) {
        if (ctx.arithmetic_expression() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression()));
            builder.append(QueryTokens.ventilated(ctx.op));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_term()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_term());
    }

    @Override
    public QueryTokenStream visitArithmetic_term(EqlParser.Arithmetic_termContext ctx) {
        if (ctx.arithmetic_term() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_term()));
            builder.append(QueryTokens.ventilated(ctx.op));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_factor()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_factor());
    }

    @Override
    public QueryTokenStream visitArithmetic_factor(EqlParser.Arithmetic_factorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.op != null) {
            builder.append(QueryTokens.token(ctx.op));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_primary()));
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_primary(EqlParser.Arithmetic_primaryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.numeric_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.numeric_literal()));
        } else if (ctx.arithmetic_expression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_numerics() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.functions_returning_numerics()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.arithmetic_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_cast_function()));
        } else if (ctx.type_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.type_cast_function()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitString_expression(EqlParser.String_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.string_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_literal()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_strings() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.functions_returning_strings()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.string_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_cast_function()));
        } else if (ctx.type_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.type_cast_function()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (!ObjectUtils.isEmpty(ctx.string_expression())) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_DOUBLE_PIPE);
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetime_expression(EqlParser.Datetime_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_datetime() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.functions_returning_datetime()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.date_time_timestamp_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.date_time_timestamp_literal()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitBoolean_expression(EqlParser.Boolean_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.boolean_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.boolean_literal()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEnum_expression(EqlParser.Enum_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.enum_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.enum_literal()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntity_expression(EqlParser.Entity_expressionContext ctx) {
        if (ctx.single_valued_object_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression());
        }
        if (ctx.simple_entity_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_entity_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimple_entity_expression(EqlParser.Simple_entity_expressionContext ctx) {
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitEntity_type_expression(EqlParser.Entity_type_expressionContext ctx) {
        if (ctx.type_discriminator() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator());
        }
        if (ctx.entity_type_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entity_type_literal());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitType_discriminator(EqlParser.Type_discriminatorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TYPE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.general_identification_variable() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_numerics(EqlParser.Functions_returning_numericsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LENGTH() != null) {
            builder.append(QueryTokens.token(ctx.LENGTH()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LOCATE() != null) {
            builder.append(QueryTokens.token(ctx.LOCATE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
            if (ctx.arithmetic_expression() != null) {
                builder.append(QueryTokens.TOKEN_COMMA);
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.ABS() != null) {
            builder.append(QueryTokens.token(ctx.ABS()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.CEILING() != null) {
            builder.append(QueryTokens.token(ctx.CEILING()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.EXP() != null) {
            builder.append(QueryTokens.token(ctx.EXP()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.FLOOR() != null) {
            builder.append(QueryTokens.token(ctx.FLOOR()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LN() != null) {
            builder.append(QueryTokens.token(ctx.LN()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SIGN() != null) {
            builder.append(QueryTokens.token(ctx.SIGN()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SQRT() != null) {
            builder.append(QueryTokens.token(ctx.SQRT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.MOD() != null) {
            builder.append(QueryTokens.token(ctx.MOD()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.POWER() != null) {
            builder.append(QueryTokens.token(ctx.POWER()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.ROUND() != null) {
            builder.append(QueryTokens.token(ctx.ROUND()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SIZE() != null) {
            builder.append(QueryTokens.token(ctx.SIZE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.INDEX() != null) {
            builder.append(QueryTokens.token(ctx.INDEX()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.extract_datetime_field() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.extract_datetime_field()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_datetime(EqlParser.Functions_returning_datetimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT_DATE() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_DATE()));
        } else if (ctx.CURRENT_TIME() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_TIME()));
        } else if (ctx.CURRENT_TIMESTAMP() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_TIMESTAMP()));
        } else if (ctx.LOCAL() != null) {
            builder.append(QueryTokens.expression(ctx.LOCAL()));
            if (ctx.DATE() != null) {
                builder.append(QueryTokens.expression(ctx.DATE()));
            } else if (ctx.TIME() != null) {
                builder.append(QueryTokens.expression(ctx.TIME()));
            } else if (ctx.DATETIME() != null) {
                builder.append(QueryTokens.expression(ctx.DATETIME()));
            }
        } else if (ctx.extract_datetime_part() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.extract_datetime_part()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_strings(EqlParser.Functions_returning_stringsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CONCAT() != null) {
            builder.append(QueryTokens.token(ctx.CONCAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.string_expression(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SUBSTRING() != null) {
            builder.append(QueryTokens.token(ctx.SUBSTRING()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline(QueryTokenStream.concat(ctx.arithmetic_expression(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.TRIM() != null) {
            builder.append(QueryTokens.token(ctx.TRIM()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            if (ctx.trim_specification() != null) {
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trim_specification()));
            }
            if (ctx.trim_character() != null) {
                nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trim_character()));
            }
            if (ctx.FROM() != null) {
                nested.append(QueryTokens.expression(ctx.FROM()));
            }
            nested.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.appendInline(nested);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LOWER() != null) {
            builder.append(QueryTokens.token(ctx.LOWER()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.UPPER() != null) {
            builder.append(QueryTokens.token(ctx.UPPER()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LEFT() != null) {
            builder.append(QueryTokens.token(ctx.LEFT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.RIGHT() != null) {
            builder.append(QueryTokens.token(ctx.RIGHT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.REPLACE() != null) {
            builder.append(QueryTokens.token(ctx.REPLACE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(2)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTrim_specification(EqlParser.Trim_specificationContext ctx) {
        if (ctx.LEADING() != null) {
            return QueryTokenStream.ofToken(ctx.LEADING());
        }
        if (ctx.TRAILING() != null) {
            return QueryTokenStream.ofToken(ctx.TRAILING());
        }
        return QueryTokenStream.ofToken(ctx.BOTH());
    }

    @Override
    public QueryTokenStream visitArithmetic_cast_function(EqlParser.Arithmetic_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append(QueryTokens.token(ctx.f));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitType_cast_function(EqlParser.Type_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        if (!CollectionUtils.isEmpty(ctx.numeric_literal())) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.numeric_literal(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitString_cast_function(EqlParser.String_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append(QueryTokens.token(ctx.STRING()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitFunction_invocation(EqlParser.Function_invocationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.FUNCTION() != null) {
            builder.append(QueryTokens.token(ctx.FUNCTION()));
        } else if (ctx.identification_variable() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.function_name()));
        if (!ctx.function_arg().isEmpty()) {
            builder.append(QueryTokens.TOKEN_COMMA);
        }
        builder.appendInline(QueryTokenStream.concat(ctx.function_arg(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitExtract_datetime_field(EqlParser.Extract_datetime_fieldContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_field()));
        nested.append(QueryTokens.expression(ctx.FROM()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression()));
        builder.append(QueryTokens.token(ctx.EXTRACT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetime_field(EqlParser.Datetime_fieldContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitExtract_datetime_part(EqlParser.Extract_datetime_partContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_part()));
        nested.append(QueryTokens.expression(ctx.FROM()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression()));
        builder.append(QueryTokens.token(ctx.EXTRACT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetime_part(EqlParser.Datetime_partContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitFunction_arg(EqlParser.Function_argContext ctx) {
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        if (ctx.state_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
    }

    @Override
    public QueryTokenStream visitCase_expression(EqlParser.Case_expressionContext ctx) {
        if (ctx.general_case_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.general_case_expression());
        }
        if (ctx.simple_case_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_case_expression());
        }
        if (ctx.coalesce_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.coalesce_expression());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.nullif_expression());
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitType_literal(EqlParser.Type_literalContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        ctx.children.forEach(it -> {
            QueryRenderer.QueryRendererBuilder queryRendererBuilder2 = builder.append(QueryTokens.expression(it.getText()));
        });
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneral_case_expression(EqlParser.General_case_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.appendExpression(QueryTokenStream.concat(ctx.when_clause(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        builder.append(QueryTokens.expression(ctx.ELSE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitWhen_clause(EqlParser.When_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_case_expression(EqlParser.Simple_case_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.case_operand()));
        builder.appendExpression(QueryTokenStream.concat(ctx.simple_when_clause(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        builder.append(QueryTokens.expression(ctx.ELSE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCase_operand(EqlParser.Case_operandContext ctx) {
        if (ctx.state_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator());
    }

    @Override
    public QueryTokenStream visitSimple_when_clause(EqlParser.Simple_when_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(0)));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitCoalesce_expression(EqlParser.Coalesce_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.COALESCE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.scalar_expression(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitNullif_expression(EqlParser.Nullif_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.NULLIF()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(0)));
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(1)));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitTrim_character(EqlParser.Trim_characterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryTokenStream.ofToken(ctx.CHARACTER());
        }
        if (ctx.character_valued_input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.character_valued_input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitIdentification_variable(EqlParser.Identification_variableContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return QueryTokenStream.ofToken(ctx.IDENTIFICATION_VARIABLE());
        }
        if (ctx.type_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.type_literal());
        }
        if (ctx.f != null) {
            return QueryTokenStream.ofToken(ctx.f);
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitConstructor_name(EqlParser.Constructor_nameContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.entity_name());
    }

    @Override
    public QueryTokenStream visitLiteral(EqlParser.LiteralContext ctx) {
        if (ctx.STRINGLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.STRINGLITERAL());
        }
        if (ctx.JAVASTRINGLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.JAVASTRINGLITERAL());
        }
        if (ctx.INTLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.INTLITERAL());
        }
        if (ctx.FLOATLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.FLOATLITERAL());
        }
        if (ctx.LONGLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.LONGLITERAL());
        }
        if (ctx.boolean_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_literal());
        }
        if (ctx.entity_type_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entity_type_literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitInput_parameter(EqlParser.Input_parameterContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.INTLITERAL() != null) {
            builder.append(QueryTokens.TOKEN_QUESTION_MARK);
            builder.append(QueryTokens.token(ctx.INTLITERAL()));
        } else if (ctx.identification_variable() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitPattern_value(EqlParser.Pattern_valueContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitDate_time_timestamp_literal(EqlParser.Date_time_timestamp_literalContext ctx) {
        if (ctx.STRINGLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.STRINGLITERAL());
        }
        if (ctx.DATELITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.DATELITERAL());
        }
        if (ctx.TIMELITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.TIMELITERAL());
        }
        if (ctx.TIMESTAMPLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.TIMESTAMPLITERAL());
        }
        return QueryRenderer.builder();
    }

    @Override
    public QueryTokenStream visitEntity_type_literal(EqlParser.Entity_type_literalContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitEscape_character(EqlParser.Escape_characterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryTokenStream.ofToken(ctx.CHARACTER());
        }
        if (ctx.character_valued_input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.character_valued_input_parameter());
        }
        if (ctx.string_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.string_literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNumeric_literal(EqlParser.Numeric_literalContext ctx) {
        if (ctx.INTLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.INTLITERAL());
        }
        if (ctx.FLOATLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.FLOATLITERAL());
        }
        if (ctx.LONGLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.LONGLITERAL());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBoolean_literal(EqlParser.Boolean_literalContext ctx) {
        if (ctx.TRUE() != null) {
            return QueryTokenStream.ofToken(ctx.TRUE());
        }
        if (ctx.FALSE() != null) {
            return QueryTokenStream.ofToken(ctx.FALSE());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitEnum_literal(EqlParser.Enum_literalContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression());
    }

    @Override
    public QueryTokenStream visitString_literal(EqlParser.String_literalContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryTokenStream.ofToken(ctx.CHARACTER());
        }
        if (ctx.STRINGLITERAL() != null) {
            return QueryTokenStream.ofToken(ctx.STRINGLITERAL());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSingle_valued_embeddable_object_field(EqlParser.Single_valued_embeddable_object_fieldContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitSubtype(EqlParser.SubtypeContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitCollection_valued_field(EqlParser.Collection_valued_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitSingle_valued_object_field(EqlParser.Single_valued_object_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitState_field(EqlParser.State_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitCollection_value_field(EqlParser.Collection_value_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitEntity_name(EqlParser.Entity_nameContext ctx) {
        return QueryTokenStream.concat(ctx.reserved_word(), arg_0 -> ((EqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitResult_variable(EqlParser.Result_variableContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitSuperquery_identification_variable(EqlParser.Superquery_identification_variableContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitCollection_valued_input_parameter(EqlParser.Collection_valued_input_parameterContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
    }

    @Override
    public QueryTokenStream visitSingle_valued_input_parameter(EqlParser.Single_valued_input_parameterContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
    }

    @Override
    public QueryTokenStream visitFunction_name(EqlParser.Function_nameContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.string_literal());
    }

    @Override
    public QueryTokenStream visitCharacter_valued_input_parameter(EqlParser.Character_valued_input_parameterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryTokenStream.ofToken(ctx.CHARACTER());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitReserved_word(EqlParser.Reserved_wordContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return QueryTokenStream.ofToken(ctx.IDENTIFICATION_VARIABLE());
        }
        if (ctx.f != null) {
            return QueryTokenStream.ofToken(ctx.f);
        }
        return QueryTokenStream.empty();
    }
}

