/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.actuate;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpanBytesEncoder;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.autoconfig.actuate.FinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.TextOutputFormat;
import org.springframework.cloud.sleuth.brave.bridge.BraveFinishedSpan;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;

class BraveFinishedSpanWriter
implements FinishedSpanWriter<String> {
    BraveFinishedSpanWriter() {
    }

    @Override
    public String write(TextOutputFormat format, List<FinishedSpan> spans) {
        if (format == TextOutputFormat.CONTENT_TYPE_OPENZIPKIN_JSON_V2) {
            return new String(MutableSpanBytesEncoder.zipkinJsonV2((Tag)Tags.ERROR).encodeList(spans.stream().map(BraveFinishedSpan::toBrave).collect(Collectors.toList())));
        }
        return null;
    }
}

