/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryContext;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.http.HttpMethod;

public class RetryableExchangeFilterFunctionLoadBalancerRetryPolicy
implements LoadBalancerRetryPolicy {
    private final LoadBalancerRetryProperties properties;

    public RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(LoadBalancerRetryProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean canRetrySameServiceInstance(LoadBalancerRetryContext context) {
        return context.getRetriesSameServiceInstance() < this.properties.getMaxRetriesOnSameServiceInstance();
    }

    @Override
    public boolean canRetryNextServiceInstance(LoadBalancerRetryContext context) {
        return context.getRetriesNextServiceInstance() < this.properties.getMaxRetriesOnNextServiceInstance();
    }

    @Override
    public boolean retryableStatusCode(int statusCode) {
        return this.properties.getRetryableStatusCodes().contains(statusCode);
    }

    @Override
    public boolean canRetryOnMethod(HttpMethod method) {
        return HttpMethod.GET.equals((Object)method) || this.properties.isRetryOnAllOperations();
    }
}

