/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.container.ContainerImageMetadata;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.BoundPropertiesTrackingBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.MethodMetadata;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@AutoConfiguration(before={DataSourceAutoConfiguration.class})
public class TestDatabaseAutoConfiguration {
    @Bean
    @Role(value=2)
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="NON_TEST", matchIfMissing=true)
    static EmbeddedDataSourceBeanFactoryPostProcessor nonTestEmbeddedDataSourceBeanFactoryPostProcessor(Environment environment) {
        return new EmbeddedDataSourceBeanFactoryPostProcessor(environment, AutoConfigureTestDatabase.Replace.NON_TEST);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="ANY")
    static EmbeddedDataSourceBeanFactoryPostProcessor embeddedDataSourceBeanFactoryPostProcessor(Environment environment) {
        return new EmbeddedDataSourceBeanFactoryPostProcessor(environment, AutoConfigureTestDatabase.Replace.ANY);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="AUTO_CONFIGURED")
    @ConditionalOnMissingBean
    public DataSource dataSource(Environment environment) {
        return new EmbeddedDataSourceFactory(environment).getEmbeddedDatabase();
    }

    @Order(value=0x7FFFFFFF)
    static class EmbeddedDataSourceBeanFactoryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final ConfigurationPropertyName DATASOURCE_URL_PROPERTY = ConfigurationPropertyName.of((CharSequence)"spring.datasource.url");
        private static final Bindable<String> BINDABLE_STRING = Bindable.of(String.class);
        private static final String DYNAMIC_VALUES_PROPERTY_SOURCE_CLASS = "org.springframework.test.context.support.DynamicValuesPropertySource";
        private static final Log logger = LogFactory.getLog(EmbeddedDataSourceBeanFactoryPostProcessor.class);
        private final Environment environment;
        private final AutoConfigureTestDatabase.Replace replace;

        EmbeddedDataSourceBeanFactoryPostProcessor(Environment environment, AutoConfigureTestDatabase.Replace replace) {
            this.environment = environment;
            this.replace = replace;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, (String)"Test Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            this.process(registry, (ConfigurableListableBeanFactory)registry);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        private void process(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
            BeanDefinitionHolder holder = this.getDataSourceBeanDefinition(beanFactory);
            if (holder != null && this.isReplaceable(beanFactory, holder)) {
                String beanName = holder.getBeanName();
                boolean primary = holder.getBeanDefinition().isPrimary();
                logger.info((Object)("Replacing '" + beanName + "' DataSource bean with " + (primary ? "primary " : "") + "embedded version"));
                registry.removeBeanDefinition(beanName);
                registry.registerBeanDefinition(beanName, this.createEmbeddedBeanDefinition(primary));
            }
        }

        private BeanDefinition createEmbeddedBeanDefinition(boolean primary) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(EmbeddedDataSourceFactoryBean.class);
            beanDefinition.setPrimary(primary);
            return beanDefinition;
        }

        private BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
            Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
            if (ObjectUtils.isEmpty((Object[])beanNames)) {
                logger.warn((Object)"No DataSource beans found, embedded version will not be used");
                return null;
            }
            if (beanNames.length == 1) {
                Object beanName = beanNames[0];
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            for (Object beanName : beanNames) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                if (!beanDefinition.isPrimary()) continue;
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            logger.warn((Object)"No primary DataSource found, embedded version will not be used");
            return null;
        }

        private boolean isReplaceable(ConfigurableListableBeanFactory beanFactory, BeanDefinitionHolder holder) {
            if (this.replace == AutoConfigureTestDatabase.Replace.NON_TEST) {
                return !this.isAutoConfigured(holder) || !this.isConnectingToTestDatabase(beanFactory);
            }
            return true;
        }

        private boolean isAutoConfigured(BeanDefinitionHolder holder) {
            BeanDefinition beanDefinition = holder.getBeanDefinition();
            if (beanDefinition instanceof AnnotatedBeanDefinition) {
                AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
                MethodMetadata factoryMethodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
                return factoryMethodMetadata != null && factoryMethodMetadata.getDeclaringClassName().startsWith("org.springframework.boot.autoconfigure.");
            }
            return false;
        }

        private boolean isConnectingToTestDatabase(ConfigurableListableBeanFactory beanFactory) {
            return this.isUsingTestServiceConnection(beanFactory) || this.isUsingTestDatasourceUrl();
        }

        private boolean isUsingTestServiceConnection(ConfigurableListableBeanFactory beanFactory) {
            for (String beanName : beanFactory.getBeanNamesForType(JdbcConnectionDetails.class)) {
                try {
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                    if (!ContainerImageMetadata.isPresent((AttributeAccessor)beanDefinition)) continue;
                    return true;
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean isUsingTestDatasourceUrl() {
            ArrayList bound = new ArrayList();
            Binder.get((Environment)this.environment, (BindHandler)new BoundPropertiesTrackingBindHandler(bound::add)).bind(DATASOURCE_URL_PROPERTY, BINDABLE_STRING);
            return !bound.isEmpty() && this.isUsingTestDatasourceUrl((ConfigurationProperty)bound.get(0));
        }

        private boolean isUsingTestDatasourceUrl(ConfigurationProperty configurationProperty) {
            return this.isBoundToDynamicValuesPropertySource(configurationProperty) || this.isTestcontainersUrl(configurationProperty);
        }

        private boolean isBoundToDynamicValuesPropertySource(ConfigurationProperty configurationProperty) {
            Origin origin = configurationProperty.getOrigin();
            if (origin instanceof PropertySourceOrigin) {
                PropertySourceOrigin origin2 = (PropertySourceOrigin)origin;
                return this.isDynamicValuesPropertySource(origin2.getPropertySource());
            }
            return false;
        }

        private boolean isDynamicValuesPropertySource(PropertySource<?> propertySource) {
            return propertySource != null && DYNAMIC_VALUES_PROPERTY_SOURCE_CLASS.equals(propertySource.getClass().getName());
        }

        private boolean isTestcontainersUrl(ConfigurationProperty configurationProperty) {
            Object value = configurationProperty.getValue();
            return value != null && value.toString().startsWith("jdbc:tc:");
        }
    }

    static class EmbeddedDataSourceFactory {
        private final Environment environment;

        EmbeddedDataSourceFactory(Environment environment) {
            this.environment = environment;
            if (environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
                HashMap<String, String> source = new HashMap<String, String>();
                source.put("spring.datasource.schema-username", "");
                source.put("spring.sql.init.username", "");
                configurableEnvironment.getPropertySources().addFirst((PropertySource)new MapPropertySource("testDatabase", source));
            }
        }

        EmbeddedDatabase getEmbeddedDatabase() {
            EmbeddedDatabaseConnection connection = (EmbeddedDatabaseConnection)this.environment.getProperty("spring.test.database.connection", EmbeddedDatabaseConnection.class, (Object)EmbeddedDatabaseConnection.NONE);
            if (EmbeddedDatabaseConnection.NONE.equals((Object)connection)) {
                connection = EmbeddedDatabaseConnection.get((ClassLoader)this.getClass().getClassLoader());
            }
            Assert.state((connection != EmbeddedDatabaseConnection.NONE ? 1 : 0) != 0, (String)"Failed to replace DataSource with an embedded database for tests. If you want an embedded database please put a supported one on the classpath or tune the replace attribute of @AutoConfigureTestDatabase.");
            return new EmbeddedDatabaseBuilder().generateUniqueName(true).setType(connection.getType()).build();
        }
    }

    static class EmbeddedDataSourceFactoryBean
    implements FactoryBean<DataSource>,
    EnvironmentAware,
    InitializingBean {
        private EmbeddedDataSourceFactory factory;
        private EmbeddedDatabase embeddedDatabase;

        EmbeddedDataSourceFactoryBean() {
        }

        public void setEnvironment(Environment environment) {
            this.factory = new EmbeddedDataSourceFactory(environment);
        }

        public void afterPropertiesSet() throws Exception {
            this.embeddedDatabase = this.factory.getEmbeddedDatabase();
        }

        public DataSource getObject() throws Exception {
            return this.embeddedDatabase;
        }

        public Class<?> getObjectType() {
            return EmbeddedDatabase.class;
        }
    }
}

