/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.events;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.HasTouchScreen;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.events.internal.EventFiringKeyboard;
import org.openqa.selenium.support.events.internal.EventFiringMouse;
import org.openqa.selenium.support.events.internal.EventFiringTouch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFiringWebDriver
implements WebDriver,
JavascriptExecutor,
TakesScreenshot,
WrapsDriver,
HasInputDevices,
HasTouchScreen {
    private final WebDriver driver;
    private final List<WebDriverEventListener> eventListeners = new ArrayList<WebDriverEventListener>();
    private final WebDriverEventListener dispatcher = (WebDriverEventListener)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), new Class[]{WebDriverEventListener.class}, new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (WebDriverEventListener eventListener : EventFiringWebDriver.this.eventListeners) {
                method.invoke((Object)eventListener, args);
            }
            return null;
        }
    });

    public EventFiringWebDriver(final WebDriver driver) {
        Class<?>[] allInterfaces = this.extractInterfaces(driver);
        this.driver = (WebDriver)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), allInterfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("getWrappedDriver".equals(method.getName())) {
                    return driver;
                }
                try {
                    return method.invoke((Object)driver, args);
                }
                catch (InvocationTargetException e) {
                    EventFiringWebDriver.this.dispatcher.onException(e.getTargetException(), driver);
                    throw e.getTargetException();
                }
            }
        });
    }

    private Class<?>[] extractInterfaces(Object object) {
        HashSet allInterfaces = new HashSet();
        allInterfaces.add(WrapsDriver.class);
        if (object instanceof WebElement) {
            allInterfaces.add(WrapsElement.class);
        }
        this.extractInterfaces(allInterfaces, object.getClass());
        return allInterfaces.toArray(new Class[allInterfaces.size()]);
    }

    private void extractInterfaces(Set<Class<?>> addTo, Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return;
        }
        Class<?>[] classes = clazz.getInterfaces();
        addTo.addAll(Arrays.asList(classes));
        this.extractInterfaces(addTo, clazz.getSuperclass());
    }

    public EventFiringWebDriver register(WebDriverEventListener eventListener) {
        this.eventListeners.add(eventListener);
        return this;
    }

    public EventFiringWebDriver unregister(WebDriverEventListener eventListener) {
        this.eventListeners.remove(eventListener);
        return this;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public void get(String url) {
        this.dispatcher.beforeNavigateTo(url, this.driver);
        this.driver.get(url);
        this.dispatcher.afterNavigateTo(url, this.driver);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        this.dispatcher.beforeFindBy(by, null, this.driver);
        List temp = this.driver.findElements(by);
        this.dispatcher.afterFindBy(by, null, this.driver);
        ArrayList<WebElement> result = new ArrayList<WebElement>(temp.size());
        for (WebElement element : temp) {
            result.add(this.createWebElement(element));
        }
        return result;
    }

    public WebElement findElement(By by) {
        this.dispatcher.beforeFindBy(by, null, this.driver);
        WebElement temp = this.driver.findElement(by);
        this.dispatcher.afterFindBy(by, null, this.driver);
        return this.createWebElement(temp);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public Object executeScript(String script, Object ... args) {
        if (this.driver instanceof JavascriptExecutor) {
            this.dispatcher.beforeScript(script, this.driver);
            Object[] usedArgs = this.unpackWrappedArgs(args);
            Object result = ((JavascriptExecutor)this.driver).executeScript(script, usedArgs);
            this.dispatcher.afterScript(script, this.driver);
            return result;
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support executing javascript");
    }

    public Object executeAsyncScript(String script, Object ... args) {
        if (this.driver instanceof JavascriptExecutor) {
            this.dispatcher.beforeScript(script, this.driver);
            Object[] usedArgs = this.unpackWrappedArgs(args);
            Object result = ((JavascriptExecutor)this.driver).executeAsyncScript(script, usedArgs);
            this.dispatcher.afterScript(script, this.driver);
            return result;
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support executing javascript");
    }

    private Object[] unpackWrappedArgs(Object ... args) {
        Object[] usedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            usedArgs[i] = this.unpackWrappedElement(args[i]);
        }
        return usedArgs;
    }

    private Object unpackWrappedElement(Object arg) {
        if (arg instanceof List) {
            List aList = (List)arg;
            ArrayList<Object> toReturn = new ArrayList<Object>();
            for (int j = 0; j < aList.size(); ++j) {
                toReturn.add(this.unpackWrappedElement(aList.get(j)));
            }
            return toReturn;
        }
        if (arg instanceof Map) {
            Map aMap = (Map)arg;
            HashMap toReturn = new HashMap();
            for (Object key : aMap.keySet()) {
                toReturn.put(key, this.unpackWrappedElement(aMap.get(key)));
            }
            return toReturn;
        }
        if (arg instanceof EventFiringWebElement) {
            return ((EventFiringWebElement)arg).getWrappedElement();
        }
        return arg;
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        if (this.driver instanceof TakesScreenshot) {
            return (X)((TakesScreenshot)this.driver).getScreenshotAs(target);
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support taking screenshots");
    }

    public WebDriver.TargetLocator switchTo() {
        return new EventFiringTargetLocator(this.driver.switchTo());
    }

    public WebDriver.Navigation navigate() {
        return new EventFiringNavigation(this.driver.navigate());
    }

    public WebDriver.Options manage() {
        return new EventFiringOptions(this.driver.manage());
    }

    private WebElement createWebElement(WebElement from) {
        return new EventFiringWebElement(from);
    }

    public Keyboard getKeyboard() {
        if (this.driver instanceof HasInputDevices) {
            return new EventFiringKeyboard(this.driver, this.dispatcher);
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    public Mouse getMouse() {
        if (this.driver instanceof HasInputDevices) {
            return new EventFiringMouse(this.driver, this.dispatcher);
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    public TouchScreen getTouch() {
        if (this.driver instanceof HasTouchScreen) {
            return new EventFiringTouch(this.driver, this.dispatcher);
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    @Beta
    private class EventFiringWindow
    implements WebDriver.Window {
        private final WebDriver.Window window;

        EventFiringWindow(WebDriver.Window window) {
            this.window = window;
        }

        public void setSize(Dimension targetSize) {
            this.window.setSize(targetSize);
        }

        public void setPosition(Point targetLocation) {
            this.window.setPosition(targetLocation);
        }

        public Dimension getSize() {
            return this.window.getSize();
        }

        public Point getPosition() {
            return this.window.getPosition();
        }
    }

    private class EventFiringTargetLocator
    implements WebDriver.TargetLocator {
        private WebDriver.TargetLocator targetLocator;

        private EventFiringTargetLocator(WebDriver.TargetLocator targetLocator) {
            this.targetLocator = targetLocator;
        }

        public WebDriver frame(int frameIndex) {
            return this.targetLocator.frame(frameIndex);
        }

        public WebDriver frame(String frameName) {
            return this.targetLocator.frame(frameName);
        }

        public WebDriver frame(WebElement frameElement) {
            return this.targetLocator.frame(frameElement);
        }

        public WebDriver window(String windowName) {
            return this.targetLocator.window(windowName);
        }

        public WebDriver defaultContent() {
            return this.targetLocator.defaultContent();
        }

        public WebElement activeElement() {
            return this.targetLocator.activeElement();
        }

        public Alert alert() {
            return this.targetLocator.alert();
        }
    }

    private class EventFiringTimeouts
    implements WebDriver.Timeouts {
        private final WebDriver.Timeouts timeouts;

        EventFiringTimeouts(WebDriver.Timeouts timeouts) {
            this.timeouts = timeouts;
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            this.timeouts.implicitlyWait(time, unit);
            return this;
        }

        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            this.timeouts.setScriptTimeout(time, unit);
            return this;
        }

        public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
            this.timeouts.pageLoadTimeout(time, unit);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringOptions
    implements WebDriver.Options {
        private WebDriver.Options options;

        private EventFiringOptions(WebDriver.Options options) {
            this.options = options;
        }

        public Logs logs() {
            return this.options.logs();
        }

        public void addCookie(Cookie cookie) {
            this.options.addCookie(cookie);
        }

        public void deleteCookieNamed(String name) {
            this.options.deleteCookieNamed(name);
        }

        public void deleteCookie(Cookie cookie) {
            this.options.deleteCookie(cookie);
        }

        public void deleteAllCookies() {
            this.options.deleteAllCookies();
        }

        public Set<Cookie> getCookies() {
            return this.options.getCookies();
        }

        public Cookie getCookieNamed(String name) {
            return this.options.getCookieNamed(name);
        }

        public WebDriver.Timeouts timeouts() {
            return new EventFiringTimeouts(this.options.timeouts());
        }

        public WebDriver.ImeHandler ime() {
            throw new UnsupportedOperationException("Driver does not support IME interactions");
        }

        @Beta
        public WebDriver.Window window() {
            return new EventFiringWindow(this.options.window());
        }
    }

    private class EventFiringNavigation
    implements WebDriver.Navigation {
        private final WebDriver.Navigation navigation;

        EventFiringNavigation(WebDriver.Navigation navigation) {
            this.navigation = navigation;
        }

        public void to(String url) {
            EventFiringWebDriver.this.dispatcher.beforeNavigateTo(url, EventFiringWebDriver.this.driver);
            this.navigation.to(url);
            EventFiringWebDriver.this.dispatcher.afterNavigateTo(url, EventFiringWebDriver.this.driver);
        }

        public void to(URL url) {
            this.to(String.valueOf(url));
        }

        public void back() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateBack(EventFiringWebDriver.this.driver);
            this.navigation.back();
            EventFiringWebDriver.this.dispatcher.afterNavigateBack(EventFiringWebDriver.this.driver);
        }

        public void forward() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateForward(EventFiringWebDriver.this.driver);
            this.navigation.forward();
            EventFiringWebDriver.this.dispatcher.afterNavigateForward(EventFiringWebDriver.this.driver);
        }

        public void refresh() {
            this.navigation.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringWebElement
    implements WebElement,
    WrapsElement,
    WrapsDriver,
    Locatable {
        private final WebElement element;
        private final WebElement underlyingElement;

        private EventFiringWebElement(final WebElement element) {
            this.element = (WebElement)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), EventFiringWebDriver.this.extractInterfaces(element), new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getWrappedElement")) {
                        return element;
                    }
                    try {
                        return method.invoke((Object)element, args);
                    }
                    catch (InvocationTargetException e) {
                        EventFiringWebDriver.this.dispatcher.onException(e.getTargetException(), EventFiringWebDriver.this.driver);
                        throw e.getTargetException();
                    }
                }
            });
            this.underlyingElement = element;
        }

        public void click() {
            EventFiringWebDriver.this.dispatcher.beforeClickOn(this.element, EventFiringWebDriver.this.driver);
            this.element.click();
            EventFiringWebDriver.this.dispatcher.afterClickOn(this.element, EventFiringWebDriver.this.driver);
        }

        public void submit() {
            this.element.submit();
        }

        public void sendKeys(CharSequence ... keysToSend) {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver);
            this.element.sendKeys(keysToSend);
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver);
        }

        public void clear() {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver);
            this.element.clear();
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver);
        }

        public String getTagName() {
            return this.element.getTagName();
        }

        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        public boolean isSelected() {
            return this.element.isSelected();
        }

        public boolean isEnabled() {
            return this.element.isEnabled();
        }

        public String getText() {
            return this.element.getText();
        }

        public boolean isDisplayed() {
            return this.element.isDisplayed();
        }

        public Point getLocation() {
            return this.element.getLocation();
        }

        public Dimension getSize() {
            return this.element.getSize();
        }

        public String getCssValue(String propertyName) {
            return this.element.getCssValue(propertyName);
        }

        public WebElement findElement(By by) {
            EventFiringWebDriver.this.dispatcher.beforeFindBy(by, this.element, EventFiringWebDriver.this.driver);
            WebElement temp = this.element.findElement(by);
            EventFiringWebDriver.this.dispatcher.afterFindBy(by, this.element, EventFiringWebDriver.this.driver);
            return EventFiringWebDriver.this.createWebElement(temp);
        }

        public List<WebElement> findElements(By by) {
            EventFiringWebDriver.this.dispatcher.beforeFindBy(by, this.element, EventFiringWebDriver.this.driver);
            List temp = this.element.findElements(by);
            EventFiringWebDriver.this.dispatcher.afterFindBy(by, this.element, EventFiringWebDriver.this.driver);
            ArrayList<WebElement> result = new ArrayList<WebElement>(temp.size());
            for (WebElement element : temp) {
                result.add(EventFiringWebDriver.this.createWebElement(element));
            }
            return result;
        }

        public WebElement getWrappedElement() {
            return this.underlyingElement;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WebElement)) {
                return false;
            }
            WebElement other = (WebElement)obj;
            if (other instanceof WrapsElement) {
                other = ((WrapsElement)other).getWrappedElement();
            }
            return this.underlyingElement.equals(other);
        }

        public int hashCode() {
            return this.underlyingElement.hashCode();
        }

        public WebDriver getWrappedDriver() {
            return EventFiringWebDriver.this.driver;
        }

        public Point getLocationOnScreenOnceScrolledIntoView() {
            return ((Locatable)this.underlyingElement).getLocationOnScreenOnceScrolledIntoView();
        }

        public Coordinates getCoordinates() {
            return ((Locatable)this.underlyingElement).getCoordinates();
        }
    }
}

