/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.BiFunction;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class UrlCoercer
extends TypeCoercer<URL> {
    UrlCoercer() {
    }

    @Override
    public boolean test(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, URL> apply(Type type) {
        return (jsonInput, propertySetting) -> {
            String toCoerce;
            switch (jsonInput.peek()) {
                case NAME: {
                    toCoerce = jsonInput.nextName();
                    break;
                }
                case STRING: {
                    toCoerce = jsonInput.nextString();
                    break;
                }
                default: {
                    throw new JsonException("Unable to coerce type to URL: " + String.valueOf((Object)jsonInput.peek()));
                }
            }
            try {
                return new URL(toCoerce);
            }
            catch (MalformedURLException e) {
                throw new JsonException(e);
            }
        };
    }
}

