/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.iphone;

import java.net.URL;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhoneDriver
extends RemoteWebDriver
implements TakesScreenshot {
    protected static final String DEFAULT_IWEBDRIVER_URL = "http://localhost:3001/wd/hub";

    public IPhoneDriver(CommandExecutor executor) {
        super(executor, (Capabilities)DesiredCapabilities.iphone());
    }

    public IPhoneDriver(URL remoteAddress) throws Exception {
        super(remoteAddress, (Capabilities)DesiredCapabilities.iphone());
    }

    public IPhoneDriver(String remoteAddress) throws Exception {
        this(new URL(remoteAddress));
    }

    public IPhoneDriver() throws Exception {
        this(DEFAULT_IWEBDRIVER_URL);
    }

    public IPhoneDriver(Capabilities ignored) throws Exception {
        this();
    }

    public void close() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public WebDriver.TargetLocator switchTo() {
        return new IPhoneTargetLocator();
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        byte[] base64Png = (byte[])this.execute("screenshot").getValue();
        String png = new String(base64Png);
        return (X)target.convertFromBase64Png(png);
    }

    private class IPhoneTargetLocator
    implements WebDriver.TargetLocator {
        private IPhoneTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            throw new UnsupportedOperationException("Frame switching is not supported on the iPhone");
        }

        public WebDriver frame(String frameName) {
            throw new UnsupportedOperationException("Frame switching is not supported on the iPhone");
        }

        public WebDriver frame(WebElement frameElement) {
            throw new UnsupportedOperationException("Frame switching is not supported on the iPhone");
        }

        public WebDriver window(String windowName) {
            throw new UnsupportedOperationException("Window switching is unsupported on the iPhone");
        }

        public WebDriver defaultContent() {
            return IPhoneDriver.this;
        }

        public WebElement activeElement() {
            return (WebElement)IPhoneDriver.this.executeScript("return document.activeElement || document.body;", new Object[0]);
        }

        public Alert alert() {
            throw new UnsupportedOperationException("alert()");
        }
    }
}

