/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class NewNodeSession
implements HttpHandler {
    private final Node node;
    private final Json json;

    NewNodeSession(Node node, Json json) {
        this.node = (Node)Require.nonNull((String)"Node", (Object)node);
        this.json = (Json)Require.nonNull((String)"Json converter", (Object)json);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        CreateSessionRequest incoming = (CreateSessionRequest)this.json.toType(Contents.string((HttpMessage)req), CreateSessionRequest.class);
        Either<WebDriverException, CreateSessionResponse> result = this.node.newSession(incoming);
        HashMap value = new HashMap();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (result.isRight()) {
            response.put("sessionResponse", result.right());
        } else {
            WebDriverException exception = (WebDriverException)result.left();
            response.put("exception", Map.of("error", exception.getClass(), "message", exception.getMessage()));
        }
        value.put("value", response);
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(value));
    }
}

