/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.interactions;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.interactions.KeysRelatedAction;

public abstract class SingleKeyAction
extends KeysRelatedAction {
    protected final Keys key;
    private static final Keys[] MODIFIER_KEYS = new Keys[]{Keys.SHIFT, Keys.CONTROL, Keys.ALT};

    protected SingleKeyAction(WebDriver parent, Keys key) {
        this(parent, null, key);
    }

    protected SingleKeyAction(WebDriver parent, WebElement toElement, Keys key) {
        super(parent, toElement);
        this.key = key;
        boolean isModifier = false;
        for (Keys modifier : MODIFIER_KEYS) {
            isModifier |= modifier.equals(key);
        }
        if (!isModifier) {
            throw new IllegalArgumentException("Key Down / Up events only make sense for modifier keys.");
        }
    }
}

