/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.configuration;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.core.configuration.ConfigurationDataType;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.configuration.ConfigurationProblemReporter;

public class ConfigurationParser {
    private static final Pattern LINE = Pattern.compile("(?:clear\\s+([^=]+))|(?:(\\S*?)\\s*([-+]?=)\\s*(.*?))");
    private static final Pattern NEWLINE_FINDER = Pattern.compile("^\\s*(.*?)\\s*$", 8);
    private ConfigurationProblemReporter reporter;

    public ConfigurationParser(ConfigurationProblemReporter reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter");
        }
        this.reporter = reporter;
    }

    public void parse(CharSequence content, String contentDescription, Collector collector) {
        Map<String, ConfigurationKey<?>> registeredKeys = ConfigurationKey.registeredKeys();
        int lineNumber = 0;
        Matcher lineMatcher = NEWLINE_FINDER.matcher(content);
        while (lineMatcher.find()) {
            boolean listOperator;
            String stringValue;
            CharSequence line = content.subSequence(lineMatcher.start(1), lineMatcher.end(1));
            ++lineNumber;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            Matcher matcher = LINE.matcher(line);
            if (!matcher.matches()) {
                this.reporter.report(contentDescription, "Invalid line", lineNumber, line);
                continue;
            }
            String operator = null;
            String keyName = null;
            if (matcher.group(1) == null) {
                keyName = matcher.group(2);
                operator = matcher.group(3);
                stringValue = matcher.group(4);
            } else {
                keyName = matcher.group(1);
                operator = "clear";
                stringValue = null;
            }
            ConfigurationKey<?> key = registeredKeys.get(keyName);
            if (key == null) {
                this.reporter.report(contentDescription, "Unknown key '" + keyName + "'", lineNumber, line);
                continue;
            }
            ConfigurationDataType type = key.getType();
            boolean bl = listOperator = operator.equals("+=") || operator.equals("-=");
            if (listOperator && !type.isList()) {
                this.reporter.report(contentDescription, "'" + keyName + "' is not a list and doesn't support " + operator + " (only = and clear)", lineNumber, line);
                continue;
            }
            if (operator.equals("=") && type.isList()) {
                this.reporter.report(contentDescription, "'" + keyName + "' is a list and cannot be assigned to (use +=, -= and clear instead)", lineNumber, line);
                continue;
            }
            Object value = null;
            if (stringValue != null) {
                try {
                    value = type.getParser().parse(stringValue);
                }
                catch (Exception e) {
                    this.reporter.report(contentDescription, "Error while parsing the value for '" + keyName + "' value '" + stringValue + "' (should be " + type.getParser().exampleValue() + ")", lineNumber, line);
                    continue;
                }
            }
            if (operator.equals("clear")) {
                collector.clear(key, contentDescription, lineNumber);
                continue;
            }
            if (operator.equals("=")) {
                collector.set(key, value, contentDescription, lineNumber);
                continue;
            }
            if (operator.equals("+=")) {
                collector.add(key, value, contentDescription, lineNumber);
                continue;
            }
            collector.remove(key, value, contentDescription, lineNumber);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Collector {
        public void clear(ConfigurationKey<?> var1, String var2, int var3);

        public void set(ConfigurationKey<?> var1, Object var2, String var3, int var4);

        public void add(ConfigurationKey<?> var1, Object var2, String var3, int var4);

        public void remove(ConfigurationKey<?> var1, Object var2, String var3, int var4);
    }
}

