/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.trait.MavenDependency;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public class ExplicitDependencyVersion
extends Recipe {
    transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);

    public String getDisplayName() {
        return "Add explicit dependency versions";
    }

    public String getDescription() {
        return "Add explicit dependency versions to POMs for reproducibility, as the `LATEST` and `RELEASE` version keywords are deprecated.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final LatestRelease latestRelease = new LatestRelease(null);
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                String versionValue;
                Xml.Tag t = super.visitTag(tag, ctx);
                if ((this.isDependencyTag() || this.isManagedDependencyTag()) && ("LATEST".equals(versionValue = this.getResolutionResult().getPom().getValue(t.getChildValue("version").orElse(null))) || "RELEASE".equals(versionValue))) {
                    String groupId = this.getResolutionResult().getPom().getValue(t.getChildValue("groupId").orElse(null));
                    String artifactId = this.getResolutionResult().getPom().getValue(t.getChildValue("artifactId").orElse(null));
                    if (groupId != null && artifactId != null) {
                        try {
                            String newerVersion = MavenDependency.findNewerVersion(groupId, artifactId, null, this.getResolutionResult(), ExplicitDependencyVersion.this.metadataFailures, (VersionComparator)latestRelease, ctx);
                            if (newerVersion != null) {
                                t = this.changeChildTagValue(t, "version", newerVersion, ctx);
                                this.maybeUpdateModel();
                            }
                        }
                        catch (MavenDownloadingException e) {
                            return e.warn(t);
                        }
                    }
                }
                return t;
            }
        };
    }
}

