/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.solr.ElementModifier;
import org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr;

public class WikittyQueryVisitorToSolr
extends WikittyQueryVisitor {
    private static Log log = LogFactory.getLog(WikittyQueryVisitorToSolr.class);
    protected WikittyTransaction tx;
    protected WikittySearchEngineSolr searchEngine;
    protected ElementModifier elementModifier;
    protected String solrQuery = "";
    protected int wikittyFieldSearchDepth;

    public String getSolrQuery() {
        return this.solrQuery;
    }

    public WikittyQueryVisitorToSolr(WikittyTransaction tx, WikittySearchEngineSolr solrServer, ElementModifier elementModifier, int wikittyFieldSearchDepth) {
        this.tx = tx;
        this.searchEngine = solrServer;
        this.elementModifier = elementModifier;
        this.wikittyFieldSearchDepth = wikittyFieldSearchDepth;
    }

    private String fixSolrBug(String element2solr, String value) {
        String result = value;
        if (element2solr.equals("#fulltext") || element2solr.startsWith("#ft.all") || element2solr.endsWith("_t") || element2solr.endsWith("_c")) {
            result = StringUtils.stripAccents((String)result);
            result = result.toLowerCase();
        }
        return result;
    }

    private String element2solr(Element element) {
        String result = this.elementModifier.convertToSolr(this.tx, element);
        return result;
    }

    private String escape2solr(String value) {
        if (value == null) {
            throw new WikittyException("Parse error, value must be not empty");
        }
        String LUCENE_REPLACE_PATTERN = "\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:";
        String result = value.replaceAll("\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:", "\\\\$0");
        if (result.contains(" ")) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    protected List<String> evalConditionValueAsList(List<ConditionValue> o) {
        ArrayList<String> result = new ArrayList<String>(o.size());
        for (ConditionValue c : o) {
            result.addAll(this.evalConditionValueAsList(c));
        }
        return result;
    }

    protected List<String> evalConditionValueAsList(ConditionValue o) {
        ArrayList<String> result = new ArrayList<String>();
        if (o instanceof Select) {
            WikittyQuery query = new WikittyQuery((Condition)o);
            WikittyQueryResult<String> selectResult = this.searchEngine.findAllByQuery(this.tx, query);
            for (String s : selectResult) {
                result.add(this.escape2solr(s));
            }
        } else if (o instanceof ConditionValueString) {
            result.add(this.escape2solr(((ConditionValueString)o).getValue()));
        } else {
            throw new WikittyException(String.format("ConditionValue type unsupported %s", ClassUtils.getShortCanonicalName((Object)o, (String)"null")));
        }
        return result;
    }

    protected String evalConditionValue(ConditionValue o) {
        String result;
        if (o instanceof Select) {
            WikittyQuery query = new WikittyQuery((Condition)o);
            WikittyQueryResult<String> selectResult = this.searchEngine.findAllByQuery(this.tx, query);
            if (selectResult.size() == 0) {
                throw new WikittyException(String.format("Select return no result query was '%s' transformed to '%s'", o.toString(), selectResult.getQueryString()));
            }
            if (selectResult.size() > 1 && log.isWarnEnabled()) {
                log.warn((Object)String.format("Select return more than one result, only first is used. Query was '%s' transformed to '%s'", o.toString(), selectResult.getQueryString()));
            }
            result = (String)selectResult.peek();
        } else if (o instanceof ConditionValueString) {
            result = ((ConditionValueString)o).getValue();
        } else {
            throw new WikittyException(String.format("ConditionValue type unsupported %s", ClassUtils.getShortCanonicalName((Object)o, (String)"null")));
        }
        result = this.escape2solr(result);
        return result;
    }

    protected String deepSearchOnWikittyField(String query, String element2solr, String operator, Collection<String> values) {
        WikittyQuery sub;
        WikittyQueryResult<String> subResult;
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter deepSearchOnWikittyField query: " + query + " element2solr:" + element2solr + " values:" + values));
        }
        if (this.wikittyFieldSearchDepth > 0 && (element2solr == null || element2solr.endsWith("_w") || element2solr.startsWith("#all") || element2solr.startsWith("#ft.all")) && (subResult = this.searchEngine.findAllByQuery(this.tx, sub = new WikittyQueryMaker().containsOne((Element)Element.ALL_FIELD, values).end().setLimit(Integer.MAX_VALUE).setWikittyFieldSearchDepth(this.wikittyFieldSearchDepth - 1))).size() > 0) {
            query = "(" + query + " " + operator + " ";
            String subResultString = "*" + StringUtils.join(subResult, (String)"* OR *") + "*";
            query = element2solr == null ? query + "(" + subResultString + ")" : query + element2solr + ":(" + subResultString + ")";
            query = query + ")";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exit deepSearchOnWikittyField query: " + query));
        }
        return query;
    }

    protected String deepSearchOnWikittyField(String query, String element2solr, String operateur, String value) {
        return this.deepSearchOnWikittyField(query, element2solr, operateur, Collections.singleton(value));
    }

    public void visit(ConditionValueString o) {
    }

    public boolean visitEnter(WikittyQuery o) {
        return true;
    }

    public void visitLeave(WikittyQuery o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(And o) {
        this.solrQuery = this.solrQuery + "(";
        return true;
    }

    public boolean visitMiddle(And o) {
        this.solrQuery = this.solrQuery + " AND ";
        return true;
    }

    public void visitLeave(And o, boolean enterResult) {
        this.solrQuery = this.solrQuery + ")";
    }

    public boolean visitEnter(Or o) {
        this.solrQuery = this.solrQuery + "(";
        return true;
    }

    public boolean visitMiddle(Or o) {
        this.solrQuery = this.solrQuery + " OR ";
        return true;
    }

    public void visitLeave(Or o, boolean enterResult) {
        this.solrQuery = this.solrQuery + ")";
    }

    public boolean visitEnter(Select o) {
        return true;
    }

    public void visitLeave(Select o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Not o) {
        this.solrQuery = this.solrQuery + "NOT(";
        return true;
    }

    public void visitLeave(Not o, boolean enterResult) {
        this.solrQuery = this.solrQuery + ")";
    }

    public boolean visitEnter(Between o) {
        String element2solr = this.element2solr(o.getElement());
        String min = this.evalConditionValue(o.getMin());
        String max = this.evalConditionValue(o.getMax());
        min = this.fixSolrBug(element2solr, min);
        max = this.fixSolrBug(element2solr, max);
        this.solrQuery = this.solrQuery + element2solr + ":[" + min + " TO " + max + "]";
        return false;
    }

    public boolean visitMiddle(Between o) {
        return true;
    }

    public void visitLeave(Between o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(ContainsAll o) {
        List<String> values = this.evalConditionValueAsList(o.getValues());
        if (values.size() == 0) {
            this.solrQuery = this.solrQuery + "( *:* - *:* )";
        } else {
            String element2solr = this.element2solr(o.getElement());
            this.solrQuery = this.solrQuery + element2solr + ":(";
            String sep = "";
            for (String e : values) {
                this.solrQuery = this.solrQuery + sep + this.fixSolrBug(element2solr, e);
                sep = " AND ";
            }
            this.solrQuery = this.solrQuery + ")";
        }
        return false;
    }

    public boolean visitMiddle(ContainsAll o) {
        return false;
    }

    public void visitLeave(ContainsAll o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(ContainsOne o) {
        List<String> values = this.evalConditionValueAsList(o.getValues());
        if (values.size() == 0) {
            this.solrQuery = this.solrQuery + "( *:* - *:* )";
        } else {
            String element2solr = this.element2solr(o.getElement());
            String query = element2solr + ":(";
            String sep = "";
            for (String e : values) {
                query = query + sep + this.fixSolrBug(element2solr, e);
                sep = " OR ";
            }
            query = query + ")";
            this.solrQuery = this.solrQuery + this.deepSearchOnWikittyField(query, element2solr, "OR", values);
        }
        return false;
    }

    public boolean visitMiddle(ContainsOne o) {
        return false;
    }

    public void visitLeave(ContainsOne o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Equals o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        if (element2solr.endsWith("_s") && o.isIgnoreCaseAndAccent()) {
            element2solr = element2solr + "_c";
        }
        value = this.fixSolrBug(element2solr, value);
        String query = element2solr + ":" + value;
        this.solrQuery = this.solrQuery + this.deepSearchOnWikittyField(query, element2solr, "OR", value);
        return false;
    }

    public void visitLeave(Equals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(NotEquals o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        if (element2solr.endsWith("_s") && o.isIgnoreCaseAndAccent()) {
            element2solr = element2solr + "_c";
        }
        value = this.fixSolrBug(element2solr, value);
        String query = "-" + element2solr + ":" + value;
        this.solrQuery = this.solrQuery + this.deepSearchOnWikittyField(query, element2solr, "AND NOT", value);
        return false;
    }

    public void visitLeave(NotEquals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Greater o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        value = this.fixSolrBug(element2solr, value);
        this.solrQuery = this.solrQuery + element2solr + ":{" + value + " TO *}";
        return false;
    }

    public void visitLeave(Greater o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(GreaterOrEquals o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        value = this.fixSolrBug(element2solr, value);
        this.solrQuery = this.solrQuery + element2solr + ":[" + value + " TO *]";
        return false;
    }

    public void visitLeave(GreaterOrEquals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Keyword o) {
        String value = this.evalConditionValue(o.getValue());
        value = this.fixSolrBug("#fulltext", value);
        String query = value = "*" + value + "*";
        this.solrQuery = this.solrQuery + this.deepSearchOnWikittyField(query, null, "OR", value);
        return false;
    }

    public void visitLeave(Keyword o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Less o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        value = this.fixSolrBug(element2solr, value);
        this.solrQuery = this.solrQuery + element2solr + ":{* TO " + value + "}";
        return false;
    }

    public void visitLeave(Less o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(LessOrEquals o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        value = this.fixSolrBug(element2solr, value);
        this.solrQuery = this.solrQuery + element2solr + ":[* TO " + value + "]";
        return false;
    }

    public void visitLeave(LessOrEquals o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Like o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        if (element2solr.endsWith("_s")) {
            element2solr = element2solr + "_t";
        }
        value = this.fixSolrBug(element2solr, value);
        String query = element2solr + ":" + value;
        this.solrQuery = this.solrQuery + this.deepSearchOnWikittyField(query, element2solr, "OR", value);
        return false;
    }

    public void visitLeave(Like o, boolean enterOrMiddleResult) {
    }

    public boolean visitEnter(Unlike o) {
        String element2solr = this.element2solr(o.getElement());
        String value = this.evalConditionValue(o.getValue());
        if (element2solr.endsWith("_s")) {
            element2solr = element2solr + "_t";
        }
        value = this.fixSolrBug(element2solr, value);
        String query = "-" + element2solr + ":" + value;
        this.solrQuery = this.solrQuery + this.deepSearchOnWikittyField(query, element2solr, "AND NOT", value);
        return false;
    }

    public void visitLeave(Unlike o, boolean enterOrMiddleResult) {
    }

    public void visit(Null o) {
        this.solrQuery = this.solrQuery + "#null_field-" + o.getElement().getValue() + ":true";
    }

    public void visit(NotNull o) {
        this.solrQuery = this.solrQuery + "#null_field-" + o.getElement().getValue() + ":false";
    }

    public void visit(True o) {
        this.solrQuery = this.solrQuery + "( *:* )";
    }

    public void visit(False o) {
        this.solrQuery = this.solrQuery + "( *:* - *:* )";
    }

    public void defaultVisit(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    public boolean defaultVisitEnter(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    public boolean defaultVisitMiddle(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    public void defaultVisitLeave(Object o, boolean enterResult) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }
}

