/*
 * #%L
 * Wikitty :: wikitty-solr-impl
 * 
 * $Id: WikittyQueryParser.java 863 2011-05-06 02:09:38Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1.2/wikitty-solr/src/main/java/org/nuiton/wikitty/storage/solr/WikittyQueryParser.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.storage.solr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.LuceneQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrQueryParser;

/**
 * Add allow leading wildcard
 * setAllowLeadingWildcard(true);
 * <br>Example: <code>{!wikitty q.op=AND df=text sort='price asc'}myfield:foo +bar -baz</code>
 * More information @see LuceneQParserPlugin
 */
public class WikittyQueryParser extends LuceneQParserPlugin {

    public static String NAME = "wikitty";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new SolrQParser(qstr, localParams, params, req);
    }

    static public class SolrQParser extends QParser {

        static private Log log = LogFactory.getLog(SolrQParser.class);
        String sortStr;
        SolrQueryParser lparser;

        public SolrQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws ParseException {

            String defaultField = getParam(CommonParams.DF);
            if (defaultField == null) {
                // TODO poussin 20101216 normalement on devrait retrouver cette
                // valeur dans la config. Mais en fait a chaque fois on passe
                // ici car defaultField est null :( alors que dans schema.xml
                // on a bien defini le defaultField :(
                defaultField = WikittySolrConstant.SOLR_FULLTEXT;
            }

            lparser = new SolrQueryParser(this, defaultField);
            lparser.setAllowLeadingWildcard(true);

            String opParam = getParam(QueryParsing.OP);
            if (opParam != null) {
                lparser.setDefaultOperator("AND".equals(opParam) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
            }

            String qstr = getString();
            if (log.isDebugEnabled()) {
                log.debug("Query parse : " + qstr);
            }
            return lparser.parse(qstr);
        }

        @Override
        public String[] getDefaultHighlightFields() {
            return new String[]{lparser.getField()};
        }
    }
}
