/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.nuiton.wikitty.jdbc;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceImpl;
import org.nuiton.wikitty.solr.WikittySearchEnginSolr;

/**
 * @author poussin
 * @version $Revision: 73 $
 *
 * Last update: $Date: 2010-06-01 12:51:23 +0200 (mar., 01 juin 2010) $
 * by : $Author: bpoussin $
 */
public class WikittyServiceJDBC extends WikittyServiceImpl {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceJDBC.class);

    public WikittyServiceJDBC() {
        extensionStorage = new WikittyExtensionStorageJDBC();
        wikittyStorage = new WikittyStorageJDBC(extensionStorage);
        searchEngin = new WikittySearchEnginSolr(extensionStorage);
    }

    public WikittyServiceJDBC(Properties config) {
        extensionStorage = new WikittyExtensionStorageJDBC(config);
        wikittyStorage = new WikittyStorageJDBC(extensionStorage, config);
        searchEngin = new WikittySearchEnginSolr(extensionStorage);
    }

}
