/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.function;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;

public class WikittyQueryFunctionWrapper
extends WikittyQueryFunction {
    private static Log log = LogFactory.getLog(WikittyQueryFunctionWrapper.class);

    public WikittyQueryFunctionWrapper(String methodName, String name, WikittyQueryFunction ... args) {
        super(methodName, name, Arrays.asList(args));
    }

    public WikittyQueryFunctionWrapper(String methodName, String name, List<WikittyQueryFunction> args) {
        super(methodName, name, args);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Map<String, Object>> call(WikittySearchEngine searchEngine, WikittyTransaction tx, WikittyQuery query, List<Map<String, Object>> data) {
        ArrayList<List<Map<String, Object>>> param = new ArrayList<List<Map<String, Object>>>();
        for (WikittyQueryFunction f : this.getArgs()) {
            param.add(f.call(searchEngine, tx, query, data));
        }
        Method method = this.getMethod(this.methodName);
        Object target = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            Class<?> clazz = method.getDeclaringClass();
            try {
                target = clazz.newInstance();
            }
            catch (Exception eee) {
                throw new IllegalStateException(String.format("Can't instanciate object needed to call function %s", this.methodName), eee);
            }
        }
        ArrayList<Iterator<Map<String, Object>>> paramIterator = new ArrayList<Iterator<Map<String, Object>>>();
        for (List list : param) {
            paramIterator.add(list.iterator());
        }
        ArrayList<Map<String, Object>> resultListMap = new ArrayList<Map<String, Object>>();
        Object var10_12 = null;
        while (this.hasNext(paramIterator)) {
            void var10_13;
            List<Map<String, Object>> list = this.next(paramIterator, (List<Map<String, Object>>)var10_13);
            Object result = this.invoke(target, method, list);
            if (!(result instanceof Map)) {
                result = WikittyUtil.singletonMap(this.getName(), result);
            }
            resultListMap.add((Map)result);
        }
        return resultListMap;
    }

    protected boolean hasNext(List<Iterator<Map<String, Object>>> paramIterator) {
        boolean result = false;
        for (Iterator<Map<String, Object>> i : paramIterator) {
            result = result || i.hasNext();
        }
        return result;
    }

    protected List<Map<String, Object>> next(List<Iterator<Map<String, Object>>> paramIterator, List<Map<String, Object>> last) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int cpt = 0;
        for (Iterator<Map<String, Object>> i : paramIterator) {
            if (i.hasNext()) {
                result.add(i.next());
            } else if (last != null) {
                result.add(last.get(cpt));
            } else {
                result.add(null);
            }
            ++cpt;
        }
        return result;
    }

    protected Object invoke(Object target, Method method, List<Map<String, Object>> p) {
        Class<?>[] pClass = method.getParameterTypes();
        Object[] param = new Object[pClass.length];
        int cpt = 0;
        for (Class<?> c : pClass) {
            Object value;
            if (Map.class.isAssignableFrom(c)) {
                value = p.get(cpt);
            } else if (Number.class.isAssignableFrom(c) || Byte.TYPE.isAssignableFrom(c) || Short.TYPE.isAssignableFrom(c) || Integer.TYPE.isAssignableFrom(c) || Long.TYPE.isAssignableFrom(c) || Float.TYPE.isAssignableFrom(c) || Double.TYPE.isAssignableFrom(c)) {
                value = WikittyUtil.toNumber(c, WikittyUtil.toBigDecimal(this.takeValue(p.get(cpt))));
            } else if (Date.class.isAssignableFrom(c)) {
                value = WikittyUtil.toDate(this.takeValue(p.get(cpt)));
            } else if (Boolean.TYPE.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
                value = WikittyUtil.toBoolean(this.takeValue(p.get(cpt)));
            } else if (byte[].class.isAssignableFrom(c)) {
                value = WikittyUtil.toBinary(this.takeValue(p.get(cpt)));
            } else if (String.class.isAssignableFrom(c)) {
                value = WikittyUtil.toString(this.takeValue(p.get(cpt)));
            } else {
                throw new ClassCastException(String.format("Object '%s' is not convertible to '%s' (accepted Number, String, Date, Boolean, byte[], Map)", p.get(cpt), c.getName()));
            }
            param[cpt] = value;
            ++cpt;
        }
        try {
            Object result = method.invoke(target, param);
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't execute function (method: '%s' args:'%s')", method, Arrays.toString(param)), eee);
        }
    }

    protected Object takeValue(Map<String, Object> map) {
        Iterator<Object> i$;
        if (map != null && (i$ = map.values().iterator()).hasNext()) {
            Object v = i$.next();
            return v;
        }
        return null;
    }
}

