package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;

public abstract class WikittyTokenAbstract extends BusinessEntityImpl implements WikittyToken {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionWikittyToken;

    private static final long serialVersionUID = 3702915710174978662L;

    @Override
    public String getUser() {
String value = WikittyTokenHelper.getUser(getWikitty());
return value;
}

    @Override
    public void setUser(String user) {
String oldValue = getUser();
WikittyTokenHelper.setUser(getWikitty(), user);
getPropertyChangeSupport().firePropertyChange(WikittyToken.FIELD_WIKITTYTOKEN_USER, oldValue, getUser());
}

    @Override
    public WikittyUser getUser(boolean exceptionIfNotLoaded) {
WikittyUser value = WikittyTokenHelper.getUser(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setUser(WikittyUser user) {
WikittyUser oldValue = getUser(false);
WikittyTokenHelper.setUser(getWikitty(), user);
getPropertyChangeSupport().firePropertyChange(WikittyToken.FIELD_WIKITTYTOKEN_USER, oldValue, getUser());
}

    @Override
    public Date getDate() {
Date value = WikittyTokenHelper.getDate(getWikitty());
return value;
}

    @Override
    public void setDate(Date date) {
Date oldValue = getDate();
WikittyTokenHelper.setDate(getWikitty(), date);
getPropertyChangeSupport().firePropertyChange(WikittyToken.FIELD_WIKITTYTOKEN_DATE, oldValue, getDate());
}

    public WikittyTokenAbstract() {
        super();
}

    public WikittyTokenAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public WikittyTokenAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionWikittyToken = new WikittyExtension(EXT_WIKITTYTOKEN,
                "4.0", // version
                WikittyUtil.tagValuesToMap(" version=\"4.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Wikitty user allowed=\"WikittyUser\" fieldIndex=\"1\"", 
                                             "Date date fieldIndex=\"2\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyToken);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return WikittyTokenHelper.toString(getWikitty());
}

} //WikittyTokenAbstract
