package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;

public abstract class WikittyAuthorisationAbstract extends BusinessEntityImpl implements WikittyAuthorisation {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionWikittyAuthorisation;

    private static final long serialVersionUID = 7221293730097477176L;

    /**
     * add WikittyAuthorisation meta-extension on given extension to this entity
     * @param extension 
     */
    public void setExtensionForMetaExtension(WikittyExtension extension) {
        extensionForMetaExtension = extension;
        WikittyAuthorisationHelper.addMetaExtension(extension, getWikitty());
}

    @Override
    public String getOwner() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyAuthorisationHelper.getOwner(getWikitty());
        } else {
            value = WikittyAuthorisationHelper.getOwner(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    @Override
    public void setOwner(String owner) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getOwner();
            WikittyAuthorisationHelper.setOwner(getWikitty(), owner);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, oldValue, getOwner());
        } else {
            oldValue = getOwner();
            WikittyAuthorisationHelper.setOwner(extensionForMetaExtension.getName(), getWikitty(), owner);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "owner");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getOwner());
        }
}

    @Override
    public Set<String> getAdmin() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getAdmin(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getAdmin(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    @Override
    public void setAdmin(Set<String> values) {
        String fieldName;
        Set<String> oldValue = getAdmin();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.setAdmin(getWikitty(), values);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN;
        } else {
            WikittyAuthorisationHelper.setAdmin(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getAdmin());
}

    @Override
    public void addAllAdmin(Collection<String> values) {
        String fieldName;
        Set<String> oldValue = getAdmin();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAllAdmin(getWikitty(), values);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN;
        } else {
            WikittyAuthorisationHelper.addAllAdmin(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getAdmin());
}

    @Override
    public void addAdmin(String... element) {
        String fieldName;
        Set<String> oldValue = getAdmin();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAdmin(getWikitty(), element);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN;
        } else {
            WikittyAuthorisationHelper.addAdmin(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getAdmin());
}

    @Override
    public void removeAdmin(String... element) {
        String fieldName;
        Set<String> oldValue = getAdmin();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeAdmin(getWikitty(), element);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN;
        } else {
            WikittyAuthorisationHelper.removeAdmin(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getAdmin());
}

    @Override
    public void clearAdmin() {
        String fieldName;
        Set<String> oldValue = getAdmin();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearAdmin(getWikitty());
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN;
        } else {
            WikittyAuthorisationHelper.clearAdmin(extensionForMetaExtension.getName(), getWikitty());
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getAdmin());
}

    @Override
    public Set<String> getWriter() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getWriter(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getWriter(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    @Override
    public void setWriter(Set<String> values) {
        String fieldName;
        Set<String> oldValue = getWriter();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.setWriter(getWikitty(), values);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER;
        } else {
            WikittyAuthorisationHelper.setWriter(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getWriter());
}

    @Override
    public void addAllWriter(Collection<String> values) {
        String fieldName;
        Set<String> oldValue = getWriter();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAllWriter(getWikitty(), values);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER;
        } else {
            WikittyAuthorisationHelper.addAllWriter(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getWriter());
}

    @Override
    public void addWriter(String... element) {
        String fieldName;
        Set<String> oldValue = getWriter();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addWriter(getWikitty(), element);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER;
        } else {
            WikittyAuthorisationHelper.addWriter(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getWriter());
}

    @Override
    public void removeWriter(String... element) {
        String fieldName;
        Set<String> oldValue = getWriter();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeWriter(getWikitty(), element);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER;
        } else {
            WikittyAuthorisationHelper.removeWriter(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getWriter());
}

    @Override
    public void clearWriter() {
        String fieldName;
        Set<String> oldValue = getWriter();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearWriter(getWikitty());
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER;
        } else {
            WikittyAuthorisationHelper.clearWriter(extensionForMetaExtension.getName(), getWikitty());
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getWriter());
}

    @Override
    public Set<String> getReader() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getReader(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getReader(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    @Override
    public void setReader(Set<String> values) {
        String fieldName;
        Set<String> oldValue = getReader();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.setReader(getWikitty(), values);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER;
        } else {
            WikittyAuthorisationHelper.setReader(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getReader());
}

    @Override
    public void addAllReader(Collection<String> values) {
        String fieldName;
        Set<String> oldValue = getReader();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAllReader(getWikitty(), values);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER;
        } else {
            WikittyAuthorisationHelper.addAllReader(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getReader());
}

    @Override
    public void addReader(String... element) {
        String fieldName;
        Set<String> oldValue = getReader();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addReader(getWikitty(), element);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER;
        } else {
            WikittyAuthorisationHelper.addReader(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getReader());
}

    @Override
    public void removeReader(String... element) {
        String fieldName;
        Set<String> oldValue = getReader();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeReader(getWikitty(), element);
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER;
        } else {
            WikittyAuthorisationHelper.removeReader(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getReader());
}

    @Override
    public void clearReader() {
        String fieldName;
        Set<String> oldValue = getReader();
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearReader(getWikitty());
            fieldName = WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER;
        } else {
            WikittyAuthorisationHelper.clearReader(extensionForMetaExtension.getName(), getWikitty());
            fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getReader());
}

    @Override
    public String getParent() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyAuthorisationHelper.getParent(getWikitty());
        } else {
            value = WikittyAuthorisationHelper.getParent(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    @Override
    public void setParent(String parent) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getParent();
            WikittyAuthorisationHelper.setParent(getWikitty(), parent);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, oldValue, getParent());
        } else {
            oldValue = getParent();
            WikittyAuthorisationHelper.setParent(extensionForMetaExtension.getName(), getWikitty(), parent);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "parent");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getParent());
        }
}

    public WikittyAuthorisationAbstract() {
        super();
}

    public WikittyAuthorisationAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public WikittyAuthorisationAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionWikittyAuthorisation = new WikittyExtension(EXT_WIKITTYAUTHORISATION,
                "1.0", // version
                WikittyUtil.tagValuesToMap(" version=\"1.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Wikitty owner unique=\"true\"", 
                                             "Wikitty admin[0-*] unique=\"true\"", 
                                             "Wikitty writer[0-*] unique=\"true\"", 
                                             "Wikitty reader[0-*] unique=\"true\"", 
                                             "Wikitty parent[0-1] unique=\"true\" documentation=\"Pointe sur un autre WikittyAuthorisation qui permet d'indiquer que les droits de l'objet courant sont les m\u00EAmes que l'objet point\u00E9e. Les droits de l'objet courant s'ajoute au droit de l'objet point\u00E9\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyAuthorisation);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return WikittyAuthorisationHelper.toString(getWikitty());
}

} //WikittyAuthorisationAbstract
