/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Set;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyGroup;
import org.nuiton.wikitty.entities.WikittyGroupHelper;
import org.nuiton.wikitty.entities.WikittyGroupImpl;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittySecurityUtil {
    public static final String WIKITTY_APPADMIN_GROUP_NAME = "WikittyAppAdmin";

    public static boolean isMember(WikittyService ws, String securityToken, String userId, String groupId) {
        Set<String> members;
        Wikitty group;
        if (groupId != null && WikittyGroupHelper.hasExtension(group = WikittyServiceEnhanced.restore(ws, securityToken, groupId)) && (members = WikittyGroupHelper.getMembers(group)) != null) {
            return members.contains(userId);
        }
        return false;
    }

    public static String getUserForToken(WikittyService ws, String securityToken) {
        String userId = null;
        if (securityToken != null) {
            Wikitty securityTokenWikitty = WikittyServiceEnhanced.restore(ws, securityToken, securityToken);
            if (securityTokenWikitty == null) {
                throw new SecurityException("bad (obsolete ?) token");
            }
            userId = WikittyTokenHelper.getUser(securityTokenWikitty);
        }
        return userId;
    }

    public static WikittyGroup createAppAdminGroup(WikittyUser user) {
        WikittyGroupImpl result = new WikittyGroupImpl();
        result.setName(WIKITTY_APPADMIN_GROUP_NAME);
        String firstUserId = user.getWikittyId();
        result.addMembers(firstUserId);
        return result;
    }
}

