/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: AbstractWikittyServiceTest.java 1136 2011-08-12 14:24:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.2/wikitty-api/src/test/java/org/nuiton/wikitty/layers/AbstractWikittyServiceTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.layers;

import org.junit.Before;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType.TYPE;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public abstract class AbstractWikittyServiceTest {

    /** a wikitty service (in memory) with a cache */ 
    protected WikittyServiceEnhanced service;

    protected static final String EXT_NAME = "myextension";
    protected static final String FIELD_NAME = "myfield";
    protected static final String VALUE = "myvalue";

    /** an extension */
    protected WikittyExtension extension;

    /** a wikitty with extension */
    private Wikitty aWikitty ;

    protected String token;

    public void setService(WikittyService service) {
        this.service = new WikittyServiceEnhanced(service);
    }

    /** create a service, an extension, a wikitty, login, and store wikitty */
    @Before
    public void setUp() throws Exception {
        extension = ExtensionFactory.create(EXT_NAME, "1")
                                    .addField(FIELD_NAME, TYPE.STRING)
                                    .extension();
    }

    public Wikitty getaWikitty() {
        if (aWikitty == null) {
            aWikitty = new WikittyImpl();
            aWikitty.addExtension(extension);
            aWikitty.setField(EXT_NAME, FIELD_NAME, VALUE);
        }
        return aWikitty;
    }


}
