/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.search.PagedResult;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ImportExportXML
implements ImportExportMethod {
    private static Log log = LogFactory.getLog(ImportExportXML.class);

    @Override
    public void importReader(WikittyClient client, Reader reader) throws Exception {
        int eventType;
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput(reader);
        WikittyExtension ext = null;
        Wikitty w = null;
        String CDATA = null;
        do {
            String name;
            eventType = xpp.next();
            String objectVersion = null;
            if (eventType == 0) {
                log.info((Object)("start XML import at " + new Date()));
                continue;
            }
            if (eventType == 2) {
                String[] extensionList;
                name = xpp.getName();
                if ("extension".equals(name)) {
                    String extName = xpp.getAttributeValue(null, "name");
                    String version = xpp.getAttributeValue(null, "version");
                    String requires = xpp.getAttributeValue(null, "requires");
                    ext = new WikittyExtension(extName, version, null, requires, new LinkedHashMap<String, FieldType>());
                    continue;
                }
                if (!"object".equals(name)) continue;
                String id = xpp.getAttributeValue(null, "id");
                objectVersion = xpp.getAttributeValue(null, "version");
                String extensions = xpp.getAttributeValue(null, "extensions");
                w = new WikittyImpl(id);
                for (String extId : extensionList = extensions.split(",")) {
                    String extVersion;
                    String extName = WikittyExtension.computeName(extId);
                    WikittyExtension e = client.restoreExtension(extId = WikittyExtension.computeId(extName, extVersion = WikittyExtension.computeVersion(extId)));
                    if (e == null) {
                        throw new WikittyException("Extension not found : " + extId);
                    }
                    w.addExtension(e);
                }
            } else {
                if (eventType == 3) {
                    String fieldName;
                    name = xpp.getName();
                    if ("extension".equals(name)) {
                        client.storeExtension(Collections.singleton(ext));
                        ext = null;
                        continue;
                    }
                    if ("object".equals(name)) {
                        w.setWikittyVersion(objectVersion);
                        client.getWikittyService().store(client.getSecurityToken(), Collections.singleton(w), true);
                        w = null;
                        continue;
                    }
                    if (ext != null && "field".equals(name)) {
                        FieldType type = new FieldType();
                        fieldName = WikittyUtil.parseField(CDATA, type);
                        ext.addField(fieldName, type);
                        continue;
                    }
                    if (ext != null && "tagvalues".equals(name)) {
                        Map<String, String> tagValues = WikittyUtil.tagValuesToMap(CDATA);
                        ext.setTagValues(tagValues);
                        continue;
                    }
                    if (w == null) continue;
                    String extensionName = WikittyExtension.extractExtensionName(name);
                    fieldName = WikittyExtension.extractFieldName(name);
                    FieldType fieldType = w.getFieldType(name);
                    Object v = WikittyUtil.fromStringForExport(fieldType, CDATA);
                    if (fieldType.isCollection()) {
                        w.addToField(extensionName, fieldName, v);
                        continue;
                    }
                    w.setField(extensionName, fieldName, v);
                    continue;
                }
                if (eventType != 4) continue;
                CDATA = xpp.getText();
            }
        } while (eventType != 1);
    }

    @Override
    public void exportWriter(WikittyClient client, Writer result, WikittyQueryResult<Wikitty> queryResult) throws Exception {
        HashSet<String> extDone = new HashSet<String>();
        result.write("<wikitty>\n");
        List<Wikitty> wikitties = queryResult.getAll();
        for (Wikitty w : wikitties) {
            String extensionList = "";
            for (WikittyExtension ext : w.getExtensions()) {
                String id = ext.getId();
                extensionList = extensionList + "," + id;
                if (extDone.contains(id)) continue;
                extDone.add(id);
                String requires = StringUtils.join(ext.getRequires(), (String)",");
                result.write("  <extension name='" + ext.getName() + "' version='" + ext.getVersion() + (StringUtils.isBlank((CharSequence)requires) ? "" : "' requires='" + requires) + "'>\n");
                Map<String, String> tagValues = ext.getTagValues();
                result.write("    <tagvalues>" + WikittyUtil.tagValuesToString(tagValues) + "</tagvalues>\n");
                for (String fieldName : ext.getFieldNames()) {
                    String def = ext.getFieldType(fieldName).toDefinition(fieldName);
                    result.write("    <field>" + def + "</field>\n");
                }
                result.write("  </extension>\n");
            }
            if (!"".equals(extensionList)) {
                extensionList = extensionList.substring(1);
            }
            result.write("  <object id='" + w.getWikittyId() + "' version='" + w.getWikittyVersion() + "' extensions='" + extensionList + "'>\n");
            for (String fieldName : w.fieldNames()) {
                FieldType type = w.getFieldType(fieldName);
                if (type.isCollection()) {
                    Object fqField = w.getFqField(fieldName);
                    if (fqField == null) continue;
                    for (Object o : (Collection)fqField) {
                        String fqFieldValue = WikittyUtil.toStringForExport(type, o);
                        if (fqFieldValue == null) continue;
                        fqFieldValue = StringEscapeUtils.escapeXml((String)fqFieldValue);
                        result.write("    <" + fieldName + ">" + fqFieldValue + "</" + fieldName + ">\n");
                    }
                    continue;
                }
                String fqFieldValue = WikittyUtil.toStringForExport(type, w.getFqField(fieldName));
                if (fqFieldValue == null) continue;
                fqFieldValue = StringEscapeUtils.escapeXml((String)fqFieldValue);
                result.write("    <" + fieldName + ">" + fqFieldValue + "</" + fieldName + ">\n");
            }
            result.write("  </object>\n");
        }
        result.write("</wikitty>\n");
    }

    @Override
    public void importReader(String securityToken, Reader reader, WikittyService ws) throws Exception {
        WikittyClient client = new WikittyClient(null, ws, securityToken);
        this.importReader(client, reader);
    }

    @Override
    public void exportWriter(String securityToken, Writer result, WikittyService ws, PagedResult<Wikitty> pagedResult) throws Exception {
        WikittyClient client = new WikittyClient(null, ws, securityToken);
        WikittyQueryResult<Wikitty> queryResult = new WikittyQueryResult<Wikitty>(pagedResult.getCriteriaName(), pagedResult.getFirstIndice(), pagedResult.getNumFound(), null, pagedResult.getQueryString(), pagedResult.getAll(), null, null, null, 0L, 0L);
        this.exportWriter(client, result, queryResult);
    }
}

