package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyAbstractGenerator", date = "Tue Jul 21 11:13:11 CEST 2015")
public abstract class WikittyI18nAbstract extends BusinessEntityImpl implements WikittyI18n {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionWikittyI18n;

    private static final long serialVersionUID = 3545231419120182321L;

    /**
     * add WikittyI18n meta-extension on given extension to this entity
     * @param extension 
     */
    public void setExtensionForMetaExtension(WikittyExtension extension) {
        extensionForMetaExtension = extension;
        WikittyI18nHelper.addMetaExtension(extension, getWikitty());
}

    @Override
    public Set<String> getTranslatableValues() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyI18nHelper.getTranslatableValues(getWikitty());
        } else {
            result = WikittyI18nHelper.getTranslatableValues(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    @Override
    public void setTranslatableValues(Set<String> values) {
        String fieldName;
        Set<String> oldValue = getTranslatableValues();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.setTranslatableValues(getWikitty(), values);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES;
        } else {
            WikittyI18nHelper.setTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslatableValues());
}

    @Override
    public void addAllTranslatableValues(Collection<String> values) {
        String fieldName;
        Set<String> oldValue = getTranslatableValues();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addAllTranslatableValues(getWikitty(), values);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES;
        } else {
            WikittyI18nHelper.addAllTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslatableValues());
}

    @Override
    public void addTranslatableValues(String... element) {
        String fieldName;
        Set<String> oldValue = getTranslatableValues();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addTranslatableValues(getWikitty(), element);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES;
        } else {
            WikittyI18nHelper.addTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslatableValues());
}

    @Override
    public void removeTranslatableValues(String... element) {
        String fieldName;
        Set<String> oldValue = getTranslatableValues();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.removeTranslatableValues(getWikitty(), element);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES;
        } else {
            WikittyI18nHelper.removeTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslatableValues());
}

    @Override
    public void clearTranslatableValues() {
        String fieldName;
        Set<String> oldValue = getTranslatableValues();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.clearTranslatableValues(getWikitty());
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES;
        } else {
            WikittyI18nHelper.clearTranslatableValues(extensionForMetaExtension.getName(), getWikitty());
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslatableValues());
}

    @Override
    public Set<String> getLang() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyI18nHelper.getLang(getWikitty());
        } else {
            result = WikittyI18nHelper.getLang(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    @Override
    public void setLang(Set<String> values) {
        String fieldName;
        Set<String> oldValue = getLang();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.setLang(getWikitty(), values);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_LANG;
        } else {
            WikittyI18nHelper.setLang(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getLang());
}

    @Override
    public void addAllLang(Collection<String> values) {
        String fieldName;
        Set<String> oldValue = getLang();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addAllLang(getWikitty(), values);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_LANG;
        } else {
            WikittyI18nHelper.addAllLang(extensionForMetaExtension.getName(), getWikitty(), values);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getLang());
}

    @Override
    public void addLang(String... element) {
        String fieldName;
        Set<String> oldValue = getLang();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addLang(getWikitty(), element);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_LANG;
        } else {
            WikittyI18nHelper.addLang(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getLang());
}

    @Override
    public void removeLang(String... element) {
        String fieldName;
        Set<String> oldValue = getLang();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.removeLang(getWikitty(), element);
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_LANG;
        } else {
            WikittyI18nHelper.removeLang(extensionForMetaExtension.getName(), getWikitty(), element);
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getLang());
}

    @Override
    public void clearLang() {
        String fieldName;
        Set<String> oldValue = getLang();
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.clearLang(getWikitty());
            fieldName = WikittyI18n.FIELD_WIKITTYI18N_LANG;
        } else {
            WikittyI18nHelper.clearLang(extensionForMetaExtension.getName(), getWikitty());
            fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
        }
        getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getLang());
}

    @Override
    public String getTranslations() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyI18nHelper.getTranslations(getWikitty());
        } else {
            value = WikittyI18nHelper.getTranslations(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    @Override
    public void setTranslations(String translations) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getTranslations();
            WikittyI18nHelper.setTranslations(getWikitty(), translations);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS, oldValue, getTranslations());
        } else {
            oldValue = getTranslations();
            WikittyI18nHelper.setTranslations(extensionForMetaExtension.getName(), getWikitty(), translations);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translations");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslations());
        }
}

    public WikittyI18nAbstract() {
        super();
}

    public WikittyI18nAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public WikittyI18nAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionWikittyI18n = new WikittyExtension(EXT_WIKITTYI18N,
                "3.0", // version
                WikittyUtil.tagValuesToMap(" version=\"3.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String translatableValues[0-*] unique=\"true\" fieldIndex=\"1\"", 
                                             "String lang[0-*] unique=\"true\" fieldIndex=\"2\"", 
                                             "String translations fieldIndex=\"3\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyI18n);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return WikittyI18nHelper.toString(getWikitty());
}

} //WikittyI18nAbstract
