/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.conditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.TerminalOperator;

public class TerminalNaryOperator
extends TerminalOperator {
    private static final long serialVersionUID = 1L;
    protected Element element;
    protected List<ConditionValue> values;

    public TerminalNaryOperator(Element element) {
        this(element, null);
    }

    public TerminalNaryOperator(Element element, Collection<ConditionValue> values) {
        this.element = element;
        if (values != null) {
            this.values = new ArrayList<ConditionValue>(values);
        }
    }

    @Override
    public boolean waitCondition() {
        return true;
    }

    @Override
    public Condition addCondition(Condition c) {
        if (!(c instanceof ConditionValue)) {
            throw new WikittyException(String.format("Only ConditionValue can be add to %s, but you try to add: %s", this.getClass().getSimpleName(), ClassUtils.getShortCanonicalName((Object)c, (String)"null")));
        }
        this.getValues().add((ConditionValue)c);
        return this;
    }

    @Override
    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk && this.values != null) {
            boolean notFirst = false;
            for (Condition condition : this.values) {
                if (notFirst) {
                    walk = visitor.visitMiddle(this);
                    if (!walk) {
                        break;
                    }
                } else {
                    notFirst = true;
                }
                condition.accept(visitor);
            }
        }
        visitor.visitLeave(this, walk);
    }

    public Element getElement() {
        return this.element;
    }

    public List<ConditionValue> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<ConditionValue>();
        }
        return this.values;
    }

    @Override
    boolean equalsDeep(Object other) {
        TerminalNaryOperator op = (TerminalNaryOperator)other;
        boolean result = ObjectUtils.equals((Object)this.getElement(), (Object)op.getElement()) && ObjectUtils.equals(this.getValues(), op.getValues());
        return result;
    }
}

