/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.services.WikittyServiceStorage;
import org.nuiton.wikitty.storage.WikittyExtensionStorageInMemory;
import org.nuiton.wikitty.storage.WikittySearchEngineInMemory;
import org.nuiton.wikitty.storage.WikittyStorageInMemory;

public class WikittyServiceInMemory
extends WikittyServiceStorage {
    private static Log log = LogFactory.getLog(WikittyServiceInMemory.class);
    protected File persistenceFile = null;

    public WikittyServiceInMemory(ApplicationConfig config) {
        super(new WikittyExtensionStorageInMemory(), new WikittyStorageInMemory(), null);
        boolean persist;
        this.searchEngine = new WikittySearchEngineInMemory((WikittyStorageInMemory)this.wikittyStorage);
        if (config != null && (persist = config.getOptionAsBoolean(WikittyConfigOption.WIKITTY_WIKITTYSERVICEINMEMORY_PERSISTENCE.getKey()))) {
            this.persistenceFile = config.getOptionAsFile(WikittyConfigOption.WIKITTY_WIKITTYSERVICEINMEMORY_PERSISTENCE_FILE.getKey());
            this.restoreFromPersistenceFile(this.persistenceFile);
        }
    }

    protected void finalize() throws Throwable {
        this.saveToPersistenceFile(this.persistenceFile);
        super.finalize();
    }

    protected void restoreFromPersistenceFile(File persistenceFile) {
        if (persistenceFile != null && persistenceFile.exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(persistenceFile));
                ((WikittyExtensionStorageInMemory)this.extensionStorage).setExtensions((Map)in.readObject());
                ((WikittyStorageInMemory)this.wikittyStorage).setWikitties((Map)in.readObject());
                in.close();
            }
            catch (Exception eee) {
                log.error((Object)("Can't read data file " + persistenceFile), (Throwable)eee);
            }
        }
    }

    public void saveToPersistenceFile(File persistenceFile) {
        if (persistenceFile != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(persistenceFile));
                out.writeObject(((WikittyExtensionStorageInMemory)this.extensionStorage).getExtensions());
                out.writeObject(((WikittyStorageInMemory)this.wikittyStorage).getWikitties());
                out.close();
            }
            catch (IOException eee) {
                log.error((Object)("Can't write data file " + persistenceFile), (Throwable)eee);
            }
        }
    }
}

