/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyLabelUtilTest.java 641 2010-12-21 15:34:09Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.1/wikitty-api/src/test/java/org/nuiton/wikitty/addons/WikittyLabelUtilTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.addons;

import org.junit.Test;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType.TYPE;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.PagedResult;

import static org.junit.Assert.assertEquals;

public class WikittyLabelUtilTest {

    @Test
    public void testFindAllByLabel() {
        WikittyConfig config = new WikittyConfig();
        WikittyService ws = WikittyServiceFactory.buildWikittyService(config);
        WikittyProxy proxy = new WikittyProxy(ws);
        WikittyExtension ext = ExtensionFactory.create("test", "1").addField("toto", TYPE.NUMERIC).extension();
        Wikitty w = new WikittyImpl();
        String id = w.getId();
        w.addExtension(ext);
        w.setField(ext.getName(), "toto", 42);
        proxy.store(w);
        WikittyLabelUtil.addLabel(proxy, id, "hello");
        PagedResult<Wikitty> wikitties = WikittyLabelUtil.findAllByLabel(proxy, "hello", 0, 1);
        assertEquals(wikitties.get(0), w);
    }
}
