/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.conform;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/spring/wikitty-test.xml"})
public class PerformanceBenchMark {
    protected static final Log log = LogFactory.getLog(PerformanceBenchMark.class);
    protected static final int WIKITTY_SIZE = 10000;
    @Autowired
    protected WikittyService wikittyService;

    @Test
    public void testPerformanceWikitty() throws Exception {
        this.testPerformanceWikitty(3);
        this.testPerformanceWikitty(50);
        this.testPerformanceWikitty(100);
    }

    protected void testPerformanceWikitty(int fieldSize) {
        WikittyExtension extension = new WikittyExtension("Performance" + fieldSize);
        for (int i = 0; i < fieldSize; ++i) {
            FieldType fieldType = new FieldType(FieldType.TYPE.STRING, 1, 1);
            extension.addField("field" + i, fieldType);
        }
        this.wikittyService.storeExtension(null, extension);
        ArrayList<WikittyImpl> wikitties = new ArrayList<WikittyImpl>(10000);
        for (int i = 0; i < 10000; ++i) {
            WikittyImpl wikitty = new WikittyImpl("Performance" + fieldSize + "id" + i);
            wikitty.addExtension(extension);
            for (int j = 0; j < fieldSize; ++j) {
                wikitty.setField("Performance" + fieldSize, "field" + j, (Object)("value" + j));
            }
            wikitties.add(wikitty);
        }
        long start = System.currentTimeMillis();
        this.wikittyService.store(null, wikitties);
        long end = System.currentTimeMillis();
        log.info((Object)("[Performance" + fieldSize + "] Write times : " + (end - start) / 1000L + "s"));
        Random random = new Random();
        start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            int nextInt = random.nextInt(10000);
            this.wikittyService.restore(null, "Performance" + fieldSize + "id" + nextInt);
        }
        end = System.currentTimeMillis();
        log.info((Object)("[Performance" + fieldSize + "] Read times : " + (end - start) / 1000L + "s"));
    }
}

