/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyExtensionMigration.java 417 2010-10-15 15:24:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/WikittyExtensionMigration.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;

/**
 * Interface used to migrate Wikitty data from one WikittyExtension version
 * to another version
 * 
 * @author poussin
 * @version $Revision: 417 $
 *
 * Last update: $Date: 2010-10-15 17:24:44 +0200 (ven., 15 oct. 2010) $
 * by : $Author: sletellier $
 */
public interface WikittyExtensionMigration {

    // TODO poussin 20090902 permit configuration of migrationRegistry by spring
    /**
     * use to put migration class for extension.
     * key: extensionName, value: migration class
     */
    static public Map<String, WikittyExtensionMigration> migrationRegistry =
            new HashMap<String, WikittyExtensionMigration>();

    /**
     * Migrate wikitty data from oldExt version to newExt.
     * 
     * @param service Wikitty service that do migration
     * @param transaction current transaction to use
     * @param wikitty Wikitty object that contains data in old version
     * extension format
     * @param oldExt old extension definition
     * @param newExt new extension definition
     * @return same wikitty as argument if nothing to do, or new wikitty
     * if some modification is done
     */
    public Wikitty migrate(WikittyService service, WikittyTransaction transaction,
            Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt);

}
