package org.nuiton.wikitty.importexport;

import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyImportExportService.FORMAT;
import org.nuiton.wikitty.search.Element;

public class ExportTask implements Runnable {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(ImportTask.class);

    protected WikittyService ws;
    protected WikittyTransaction transaction;
    protected FORMAT format;
    protected Criteria criteria;
    protected Writer writer;
    protected String securityToken;

    public ExportTask(String securityToken,
            WikittyService ws, FORMAT format, Criteria criteria, Writer writer) {
        super();
        this.securityToken = securityToken;
        this.ws = ws;
        this.transaction = new WikittyTransaction();
        this.format = format;
        this.criteria = criteria;
        this.writer = writer;
    }

    @Override
    public void run() {
        try {
            transaction.begin();
            
            // use a facet to get only extension used in export
            // used for CSV export
            criteria.addFacetField(Element.ELT_EXTENSION);
            
            PagedResult<String> pageResultId = ws.findAllByCriteria(
                    securityToken, transaction, criteria);
            long time = 0;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info("Export started");
            }
            // get Wikitty from Id
            PagedResult<Wikitty> pageResult = pageResultId.cast(securityToken, ws, transaction);

            ImportExportMethod exporter = format.ieporter();
            exporter.exportWriter(securityToken, writer, ws, transaction, pageResult);
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info("Export in (ms)" + time);
            }
            transaction.commit();
        } catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }
}
