package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  abstract class WikittyGroupAbstract extends BusinessEntityWikitty implements WikittyGroup {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyGroup;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = WikittyGroupHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        WikittyGroupHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_NAME, oldValue, getName());
}

    /**
     * getMembers :
     * @return Set<String> 
     */

    @Override
    public Set<String> getMembers() {
        Set<String> result = WikittyGroupHelper.getMembers(getWikitty());
        return result;
}

    /**
     * addMembers :
     * @param element 
     */

    @Override
    public void addMembers(String element) {
        WikittyGroupHelper.addMembers(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
}

    /**
     * removeMembers :
     * @param element 
     */

    @Override
    public void removeMembers(String element) {
        WikittyGroupHelper.removeMembers(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
}

    /**
     * clearMembers :
     */

    @Override
    public void clearMembers() {
        WikittyGroupHelper.clearMembers(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
}

    /**
     * WikittyGroupAbstract :
     */

    public WikittyGroupAbstract() {
        super();
}

    /**
     * WikittyGroupAbstract :
     * @param wikitty 
     */

    public WikittyGroupAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyGroupAbstract :
     * @param businessEntityWikitty 
     */

    public WikittyGroupAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyGroup =
                new WikittyExtension(EXT_WIKITTYGROUP,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=true", 
                                             "Wikitty members[0-*] unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyGroup);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyGroupAbstract
