/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.conform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Tree;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.conform.AbstractTestConformance;
import org.nuiton.wikitty.search.Search;

public class StorageTest
extends AbstractTestConformance {
    protected static final Log log = LogFactory.getLog(StorageTest.class);

    @Test
    public void testStoreRestoreBasics() throws Exception {
        Wikitty w = StorageTest.createBasicWikitty();
        String id = w.getId();
        this.ws.store(null, w);
        w = this.ws.restore(null, id);
        Assert.assertTrue((boolean)w.hasExtension("wikittyExt"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)w.hasField("wikittyExt", "fieldName" + i));
        }
    }

    @Test
    public void testExtensionMethod() throws Exception {
        this.ws.storeExtension(null, Arrays.asList(EXT_TEST));
        List extIds = this.ws.getAllExtensionIds(null);
        log.debug((Object)("extIds: " + extIds));
        Assert.assertEquals((long)1L, (long)extIds.size());
        WikittyExtension ext = this.ws.restoreExtension(null, (String)extIds.get(0));
        Assert.assertEquals((Object)EXT_TEST.getName(), (Object)ext.getName());
        Assert.assertEquals((Object)EXT_TEST.getVersion(), (Object)ext.getVersion());
        Assert.assertEquals((Object)EXT_TEST, (Object)ext);
    }

    @Test
    public void testExtensionRequires() throws Exception {
        this.ws.storeExtension(null, Arrays.asList(EXT_REQUIRED, EXT_REQUIRES));
        List extIds = this.ws.getAllExtensionsRequires(null, "wikittyRequired");
        log.debug((Object)("extIds: " + extIds));
        Assert.assertEquals((long)1L, (long)extIds.size());
        WikittyExtension ext = this.ws.restoreExtension(null, (String)extIds.get(0));
        Assert.assertEquals((Object)EXT_REQUIRES.getName(), (Object)ext.getName());
        Assert.assertEquals((Object)EXT_REQUIRES.getVersion(), (Object)ext.getVersion());
        Assert.assertEquals((Object)EXT_REQUIRES, (Object)ext);
    }

    @Test
    public void testStoreRestoreLists() throws Exception {
        String[] wValues;
        List<Wikitty> wikitties = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        for (String wValue : wValues = new String[]{"fieldName0 = hello,fieldName1 = 123456,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = Bonzai !,fieldName1 = 111111,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = ho ho ho !,fieldName1 = 987654,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
            ids.add(w.getId());
        }
        this.ws.store(null, wikitties);
        wikitties = this.ws.restore(null, ids);
        int wIndex = 0;
        for (String wValue : wValues) {
            Wikitty w = (Wikitty)wikitties.get(wIndex);
            int i = 0;
            for (Map.Entry<String, String> keyValuePair : StorageTest.getKeyPairs(wValue)) {
                String fieldName = "fieldName" + i;
                Assert.assertEquals((Object)fieldName, (Object)keyValuePair.getKey());
                String errorMsg = "Error check field '" + fieldName + "' on wikitty[" + i + "]";
                switch (i) {
                    case 0: {
                        Assert.assertEquals((String)errorMsg, (Object)keyValuePair.getValue(), (Object)w.getFieldAsString("wikittyExt", fieldName));
                        break;
                    }
                    case 1: {
                        Assert.assertEquals((String)errorMsg, (long)Integer.parseInt(keyValuePair.getValue()), (long)w.getFieldAsInt("wikittyExt", fieldName));
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((String)errorMsg, (Object)WikittyUtil.parseDate((String)keyValuePair.getValue()), (Object)w.getFieldAsDate("wikittyExt", fieldName));
                        break;
                    }
                    default: {
                        Assert.fail((String)("this structure should only get 3 elements, unexpected : " + keyValuePair.getKey()));
                    }
                }
                ++i;
            }
            ++wIndex;
        }
    }

    @Test
    public void testStoreRestoreNullEmpty() throws Exception {
        WikittyImpl w = null;
        try {
            this.ws.store(null, w);
            Assert.fail((String)"store(null) Must throw an exception !");
        }
        catch (Exception e) {
            // empty catch block
        }
        w = new WikittyImpl();
        String id = w.getId();
        this.ws.store(null, (Wikitty)w);
        w = this.ws.restore(null, id);
        Assert.assertEquals((Object)id, (Object)w.getId());
    }

    @Test
    public void testFieldConstraint() throws Exception {
        WikittyExtension ext = new WikittyExtension("TestConstraint", "1", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String id notNull=true", "String ext[0-n] unique=true", "String other[0-n] unique=true notNull=true"}));
        this.ws.storeExtension(null, Arrays.asList(ext));
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        try {
            this.ws.store(null, (Wikitty)w);
            Assert.assertFalse((String)"not null contraint don't work on String", (boolean)true);
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.setField("TestConstraint", "id", (Object)"toto");
        try {
            this.ws.store(null, (Wikitty)w);
            Assert.assertFalse((String)"not null contraint don't work in Collection", (boolean)true);
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.addToField("TestConstraint", "other", (Object)"titi");
        this.ws.store(null, (Wikitty)w);
        w.addToField("TestConstraint", "ext", (Object)"tata");
        w.addToField("TestConstraint", "ext", (Object)"titi");
        this.ws.store(null, (Wikitty)w);
        Wikitty w2 = this.ws.restore(null, w.getId());
        w2.addToField("TestConstraint", "ext", (Object)"tata");
        w2.addToField("TestConstraint", "ext", (Object)"toto");
        this.ws.store(null, w2);
        Wikitty w3 = this.ws.restore(null, w.getId());
        HashSet<String> set = new HashSet<String>(Arrays.asList("tata", "titi", "toto"));
        Assert.assertEquals(set, (Object)w3.getFieldAsSet("TestConstraint", "ext", String.class));
    }

    @Test
    public void testStoreFindAll() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003309,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 003309,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        this.ws.store(null, wikitties);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName1", (Object)"003309");
        Criteria criteria = Search.query((Wikitty)w).criteria().addSortDescending(EXT_TEST.getName() + ".fieldName0");
        PagedResult resultFind = this.ws.findAllByCriteria(null, criteria);
        Assert.assertEquals((long)2L, (long)resultFind.size());
        List wikittyFind = this.ws.restore(null, resultFind.getAll());
        Assert.assertEquals(wikitties.subList(0, 2), (Object)wikittyFind);
    }

    @Test
    public void testStoreFindAllFacet() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 663300,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 663300,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        this.ws.store(null, wikitties);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName1", (Object)"663300");
        Criteria criteria = Search.query((Wikitty)w).criteria().setFirstIndex(0).setEndIndex(-1).addFacetField(EXT_TEST.getName() + ".fieldName0").addFacetField(EXT_TEST.getName() + ".fieldName1");
        PagedResult resultFind = this.ws.findAllByCriteria(null, criteria);
        ArrayList facetNames = new ArrayList(resultFind.getFacetNames());
        Collections.sort(facetNames);
        Assert.assertEquals(Arrays.asList(EXT_TEST.getName() + ".fieldName0", EXT_TEST.getName() + ".fieldName1"), facetNames);
        Assert.assertEquals((long)2L, (long)resultFind.getTopic(EXT_TEST.getName() + ".fieldName0").size());
        Assert.assertEquals((long)1L, (long)resultFind.getTopic(EXT_TEST.getName() + ".fieldName1").size());
    }

    @Test
    public void testStoreFindDelete() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003301,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaiseICI,fieldName1 = 113312,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223323,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        HashMap<String, String> oldIdVersion = new HashMap<String, String>();
        for (Wikitty w : wikitties) {
            oldIdVersion.put(w.getId(), w.getVersion());
        }
        UpdateResponse response = this.ws.store(null, wikitties);
        for (Wikitty w : wikitties) {
            response.update(w);
            String v1 = w.getVersion();
            String v2 = (String)oldIdVersion.get(w.getId());
            Assert.assertNotNull((Object)v1);
            Assert.assertNotNull((Object)v2);
            Assert.assertTrue((boolean)WikittyUtil.versionGreaterThan((String)v1, (String)v2));
        }
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName0", (Object)"chaiseICI");
        Criteria criteria = Search.query((Wikitty)w).criteria();
        Wikitty resultFind = this.ws.findByCriteria(null, criteria);
        Wikitty wikittySource = (Wikitty)wikitties.get(1);
        Assert.assertEquals((Object)w.getFieldAsString(EXT_TEST.getName(), "fieldName0"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName0"));
        Assert.assertEquals((Object)wikittySource.getId(), (Object)resultFind.getId());
        Assert.assertEquals((Object)wikittySource, (Object)resultFind);
        Assert.assertEquals((Object)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName0"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName0"));
        Assert.assertEquals((Object)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName1"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName1"));
        Assert.assertEquals((Object)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName2"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName2"));
        Criteria criteria1 = Search.query().eq("id", wikittySource.getId()).criteria();
        Wikitty searchedWikitty1 = this.ws.findByCriteria(null, criteria1);
        Assert.assertNotNull((Object)searchedWikitty1);
        this.ws.delete(null, wikittySource.getId());
        Wikitty deletedObject = this.ws.restore(null, wikittySource.getId());
        Assert.assertNull((Object)deletedObject);
        Criteria criteria2 = Search.query().eq("id", wikittySource.getId()).criteria();
        Wikitty searchedWikitty2 = this.ws.findByCriteria(null, criteria2);
        Assert.assertNull((Object)searchedWikitty2);
    }

    @Test
    public void testStoreAndLabel() throws Exception {
        ArrayList<Wikitty> wikitties = StorageTest.createSampleWikitty(this.ws);
        long ts = new Date().getTime();
        Wikitty w1 = (Wikitty)wikitties.get(0);
        this.ws.addLabel(null, w1.getId(), "titi" + ts);
        this.ws.addLabel(null, w1.getId(), "toto" + ts);
        Wikitty w2 = (Wikitty)wikitties.get(1);
        this.ws.addLabel(null, w2.getId(), "tata" + ts);
        this.ws.addLabel(null, w2.getId(), "titi" + ts);
        Wikitty w3 = (Wikitty)wikitties.get(2);
        this.ws.addLabel(null, w3.getId(), "tutu" + ts);
        this.ws.addLabel(null, w3.getId(), "titi" + ts);
        Wikitty wt = this.ws.findByLabel(null, "toto" + ts);
        Assert.assertEquals((Object)w1, (Object)wt);
        Set labels = this.ws.findAllAppliedLabels(null, w2.getId());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("tata" + ts, "titi" + ts)), (Object)labels);
    }

    @Test
    public void testStoreAndClassification() throws Exception {
        ArrayList<Wikitty> wikitties = StorageTest.createSampleWikitty(this.ws);
        ArrayList<Wikitty> wikittyNodes = new ArrayList<Wikitty>();
        TreeNodeImpl root = new TreeNodeImpl();
        wikittyNodes.add(root.getWikitty());
        root.setName("MyCategoryRoot");
        for (int i = 0; i < 3; ++i) {
            TreeNodeImpl leaf = new TreeNodeImpl();
            wikittyNodes.add(leaf.getWikitty());
            leaf.setName("cat-" + i);
            leaf.setParent(root.getWikittyId());
            for (int j = 0; j < 5; ++j) {
                TreeNodeImpl subLeaf = new TreeNodeImpl();
                subLeaf.setName("subcat-" + i + "-" + j);
                subLeaf.setParent(leaf.getWikittyId());
                wikittyNodes.add(subLeaf.getWikitty());
            }
        }
        this.ws.store(null, wikittyNodes);
        Wikitty table = (Wikitty)wikitties.get(0);
        Wikitty chaise = (Wikitty)wikitties.get(1);
        Wikitty bureau = (Wikitty)wikitties.get(2);
        this.assign(chaise, root, "cat-1/subcat-1-4");
        this.assign(table, root, "cat-1");
        this.assign(bureau, root, "cat-2/subcat-2-4");
        Tree t = this.ws.restoreTree(null, root.getWikitty().getId());
        t.getName().equals("MyCategoryRoot");
    }

    private void assign(Wikitty wikitty, TreeNodeImpl root, String path) {
        String[] nodeNames = path.split("/");
        TreeNodeImpl currentNode = root;
        block0: for (String nodeName : nodeNames) {
            TreeNodeImpl node = new TreeNodeImpl();
            node.setName(nodeName);
            Criteria criteria = Search.query((Wikitty)node.getWikitty()).criteria().setFirstIndex(0).setEndIndex(-1);
            List wikittiesId = this.ws.findAllByCriteria(null, criteria).getAll();
            List wikitties = this.ws.restore(null, wikittiesId);
            for (Wikitty child : wikitties) {
                if (!child.hasExtension("TreeNode") || !(node = new TreeNodeImpl(child)).getName().equals(nodeName)) continue;
                currentNode = node;
                continue block0;
            }
            Assert.fail((String)("Unable to find node " + nodeName + " inside " + currentNode.getName()));
        }
        currentNode.addChildren(wikitty.getId());
        this.ws.store(null, currentNode.getWikitty());
    }

    @Test
    public void testWikittyUtilNewInstanceWithWikitty() {
        WikittyImpl w = new WikittyImpl();
        w.addExtension(TreeNodeImpl.extensions);
        TreeNode treeNode = (TreeNode)WikittyUtil.newInstance(null, (WikittyService)this.ws, TreeNode.class, (Wikitty)w);
        Assert.assertNotNull((Object)treeNode);
    }
}

