package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * GreatOrEqual operator is used to build restriction containing "element &gt;=
 * value" where element could be a Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.greatEq( myElement ,
 * RestrictionHelper.DATE_FORMAT.format(new Date()) )
 */
public class GreaterOrEqual extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public GreaterOrEqual() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GreaterOrEqual)) {
            return false;
        }

        final GreaterOrEqual greaterOrEqual = (GreaterOrEqual) other;

        return super.equals(greaterOrEqual);
    }

    public int hashCode() {
        int result = GreaterOrEqual.class.getName().hashCode();
        result = 29 * result + super.hashCode();
        return result;
    }

}