/*
 * #%L
 * Nuiton Web :: Nuiton Struts 2
 * 
 * $Id: HelpTag.java 152 2011-12-01 17:16:59Z athimel $
 * $HeadURL: https://svn.nuiton.org/nuiton-web/tags/nuiton-web-1.17/nuiton-struts2/src/main/java/org/nuiton/web/struts2/taglib/HelpTag.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.web.struts2.taglib;

import com.opensymphony.xwork2.util.ValueStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.jsp.ui.AbstractClosingTag;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @since 1.7
 */
public class HelpTag extends AbstractClosingTag {

    /** Logger. */
    private static final Log log = LogFactory.getLog(HelpTag.class);

    protected String helpKey;

    protected String helpZone;

    public HelpBean getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        return new HelpBean(stack, req, res);
    }

    public void setHelpKey(String helpKey) {
        this.helpKey = helpKey;
    }

    public void setHelpZone(String helpZone) {
        this.helpZone = helpZone;
    }

    @Override
    protected void populateParams() {
        HelpBean helpBean = (HelpBean) component;
        helpBean.setHelpKey(helpKey);
        helpBean.setHelpZone(helpZone);
    }
}
