/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.web.security.SecurityRole;

public abstract class SecurityRoleAbstract
extends AbstractTopiaEntity
implements SecurityRole {
    protected String name;
    protected Collection<String> permissions;
    private static final long serialVersionUID = 4049127909472219447L;

    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "permissions", Collection.class, String.class, this.permissions);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void addPermissions(String permissions) {
        if (this.permissions == null) {
            this.permissions = new LinkedList<String>();
        }
        this.permissions.add(permissions);
    }

    @Override
    public void addAllPermissions(Iterable<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String item : permissions) {
            this.addPermissions(item);
        }
    }

    @Override
    public void setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public void removePermissions(String permissions) {
        if (this.permissions == null || !this.permissions.remove(permissions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearPermissions() {
        if (this.permissions == null) {
            return;
        }
        this.permissions.clear();
    }

    @Override
    public Collection<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public int sizePermissions() {
        if (this.permissions == null) {
            return 0;
        }
        return this.permissions.size();
    }

    @Override
    public boolean isPermissionsEmpty() {
        int size = this.sizePermissions();
        return size == 0;
    }

    @Override
    public boolean isPermissionsNotEmpty() {
        boolean empty = this.isPermissionsEmpty();
        return !empty;
    }

    @Override
    public boolean containsPermissions(String permissions) {
        boolean contains = this.permissions != null && this.permissions.contains(permissions);
        return contains;
    }
}

