/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.web.SecurityTopiaApplicationContext;
import org.nuiton.web.SecurityTopiaPersistenceContext;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserTopiaDao;
import org.nuiton.web.security.SecurityUtil;

public class TopiaSecurityRealm
extends AuthorizingRealm
implements CredentialsMatcher {
    private static final Log log = LogFactory.getLog(TopiaSecurityRealm.class);
    protected SecurityTopiaApplicationContext rootContext;
    protected ApplicationConfig config;
    protected transient Map<String, SimpleAuthorizationInfo> authorizationCache;

    public TopiaSecurityRealm(SecurityTopiaApplicationContext rootContext, ApplicationConfig config) {
        this.rootContext = rootContext;
        this.config = config;
        this.authorizationCache = new HashMap<String, SimpleAuthorizationInfo>();
        this.setCredentialsMatcher(this);
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        char[] tokenCredentials = (char[])token.getCredentials();
        String submittedPassword = String.valueOf(tokenCredentials);
        String submittedHashedPassword = StringUtil.encodeMD5((String)submittedPassword);
        String expectedHashedPassword = (String)info.getCredentials();
        return expectedHashedPassword.equals(submittedHashedPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String login = (String)principals.getPrimaryPrincipal();
        SimpleAuthorizationInfo result = this.authorizationCache.get(login);
        if (result == null) {
            Properties props = this.config.getFlatOptions();
            SecurityTopiaPersistenceContext transaction = null;
            try {
                transaction = this.rootContext.newPersistenceContext();
                SecurityUserTopiaDao securityUserDAO = transaction.getSecurityUserDao();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Build autorisation list for user : " + login));
                }
                Object securityUser = securityUserDAO.findByLogin(login);
                result = new SimpleAuthorizationInfo();
                for (SecurityRole role : securityUser.getSecurityRole()) {
                    for (String permission : role.getPermissions()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("- add permission : " + permission));
                        }
                        for (String prop : props.stringPropertyNames()) {
                            String[] permTab;
                            String endProp;
                            String[] subs;
                            if (!prop.startsWith("topia.security.permission.") || (subs = (endProp = StringUtils.removeStart((String)prop, (String)"topia.security.permission.")).split("\\.")).length != 3 || !subs[2].equals("perm") || !subs[1].equals(permission)) continue;
                            String perms = props.getProperty(prop);
                            for (String perm : permTab = perms.split("\\s*\\;\\s*")) {
                                result.addStringPermission(perm);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("  string permission : " + perm));
                            }
                        }
                    }
                }
                if (login.equals("anonymous") && securityUserDAO.count() == 1L) {
                    result.addStringPermission("*");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Grant all rigth (*) because no user exists");
                    }
                }
                if (this.config.getOptionAsBoolean("topia.security.disable")) {
                    result.addStringPermission("*");
                }
                result.addStringPermission("url" + SecurityUtil.convertToShiroPerm(this.config.getOption("topia.security.loginurl"), this.config.getOption("topia.security.separators")));
                result.addStringPermission("url" + SecurityUtil.convertToShiroPerm(this.config.getOption("topia.security.logouturl"), this.config.getOption("topia.security.separators")));
                this.authorizationCache.put(login, result);
                return result;
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) return result;
                log.error((Object)"Can't get user permission", (Throwable)ex);
                return result;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        } else {
            if (!log.isTraceEnabled()) return result;
            log.trace((Object)("Using autorisation from cache for " + login));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)token;
        String login = usernamePasswordToken.getUsername();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetAuthenticationInfo for login : " + login));
        }
        SimpleAuthenticationInfo result = null;
        SecurityTopiaPersistenceContext transaction = null;
        try {
            transaction = this.rootContext.newPersistenceContext();
            SecurityUserTopiaDao securityUserDAO = transaction.getSecurityUserDao();
            SecurityUser securityUser = (SecurityUser)securityUserDAO.forLoginEquals(login).findUnique();
            if (securityUser != null) {
                result = login.equals("anonymous") ? new SimpleAuthenticationInfo((Object)securityUser.getLogin(), (Object)StringUtil.encodeMD5((String)""), this.getName()) : new SimpleAuthenticationInfo((Object)securityUser.getLogin(), (Object)securityUser.getPassword(), this.getName());
                this.authorizationCache.remove(login);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        return result;
    }
}

