package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.web.SecurityEntityEnum;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Mar 17 17:27:11 CET 2014")
public abstract class GeneratedSecurityUserTopiaDao<E extends SecurityUser> extends AbstractTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) SecurityUser.class;
    }

    @Override
    public SecurityEntityEnum getTopiaEntityEnum() {
        return SecurityEntityEnum.SecurityUser;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityUser.LOGIN, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityUser.LOGIN, v);
        return result;
    }

    @Deprecated
    public E findByLogin(String v) {
        return forLoginEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLogin(String v) {
        return forLoginEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityUser.PASSWORD, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityUser.PASSWORD, v);
        return result;
    }

    @Deprecated
    public E findByPassword(String v) {
        return forPasswordEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPassword(String v) {
        return forPasswordEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalIdIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityUser.EXTERNAL_ID, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityUser.EXTERNAL_ID, v);
        return result;
    }

    @Deprecated
    public E findByExternalId(String v) {
        return forExternalIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExternalId(String v) {
        return forExternalIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSecurityRoleContains(SecurityRole v) {
        return forContains(SecurityUser.SECURITY_ROLE, v);
    }

    @Deprecated
    public E findContainsSecurityRole(SecurityRole v) {
        return forSecurityRoleContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSecurityRole(SecurityRole v) {
        return forSecurityRoleContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedSecurityUserTopiaDao<E extends SecurityUser>
