/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityUserDAO;
import org.nuiton.web.security.actions.AbstractAction;

public class RolePermissionsAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected SecurityUserDAO securityUserDAO;
    protected SecurityRoleDAO securityRoleDAO;
    protected Map<String, String> categories;
    protected Map<String, String> permissions;
    protected Map<String, Collection<String>> categoryPermissions;
    protected List<SecurityRole> roles;
    protected List<String> roleIds;

    public String input() throws Exception {
        TopiaContext transaction = this.rootContext.beginTransaction();
        this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
        this.roles = this.securityRoleDAO.findAllWithOrder(new String[]{"name"});
        transaction.closeContext();
        this.categories = new HashMap<String, String>();
        this.permissions = new HashMap<String, String>();
        this.categoryPermissions = new HashMap<String, Collection<String>>();
        Properties props = this.config.getFlatOptions();
        for (String prop : props.stringPropertyNames()) {
            if (!prop.startsWith("topia.security.permission.")) continue;
            String endProp = StringUtils.removeStart((String)prop, (String)"topia.security.permission.");
            String[] subs = endProp.split("\\.");
            if (subs.length == 1) {
                this.categories.put(subs[0], props.getProperty(prop));
                continue;
            }
            if (subs.length != 3 || !subs[2].equals("name")) continue;
            String name = props.getProperty(prop);
            this.permissions.put(subs[1], name);
            Collection<String> categoryPermissionCol = this.categoryPermissions.get(subs[0]);
            if (categoryPermissionCol == null) {
                categoryPermissionCol = new ArrayList<String>();
                this.categoryPermissions.put(subs[0], categoryPermissionCol);
            }
            categoryPermissionCol.add(subs[1]);
        }
        return super.input();
    }

    public List<SecurityRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getCategories() {
        return this.categories;
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    public Map<String, Collection<String>> getCategoryPermissions() {
        return this.categoryPermissions;
    }

    public void setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
    }

    public String execute() throws Exception {
        String result = super.execute();
        if (this.roleIds == null) {
            result = this.input();
        } else {
            try {
                TopiaContext transaction = this.rootContext.beginTransaction();
                this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                for (String roleId : this.roleIds) {
                    SecurityRole securityRole = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                    securityRole.clearPermissions();
                    String[] permissions = this.getParameters("permissions-" + roleId);
                    if (permissions == null) continue;
                    for (String permission : permissions) {
                        securityRole.addPermissions(permission);
                    }
                }
                transaction.commitTransaction();
            }
            catch (Exception ex) {
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }
}

