/*
 * #%L
 * Nuiton Web :: Nuiton Security
 * $Id: UserAction.java 265 2013-04-30 09:03:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.13/nuiton-security/src/main/java/org/nuiton/web/security/actions/UserAction.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.web.security.actions;

import static org.nuiton.i18n.I18n._;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.util.StringUtil;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserDAO;
import org.nuiton.web.security.SecurityUserImpl;

public class UserAction extends AbstractAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(UserAction.class);

    protected SecurityUserDAO securityUserDAO;

    protected SecurityUser user;

    protected String password;

    protected String confirm;

    public SecurityUser getUser() {
        if (user == null) {
            String roleId = getParameter("userId");
            if (StringUtils.isNotBlank(roleId)) {
                try {
                    TopiaContext transaction = rootContext.beginTransaction();
                    securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
                    user = securityUserDAO.findByTopiaId(roleId);
                    transaction.closeContext();
                } catch (TopiaException ex) {
                    throw new TopiaRuntimeException(ex);
                }
            } else {
                user = new SecurityUserImpl();
            }
        }
        return user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String delete() throws Exception {
        try {
            String roleId = getParameter("userId");
            if (StringUtils.isNotBlank(roleId)) {
                TopiaContext transaction = rootContext.beginTransaction();
                securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
                SecurityUser user = securityUserDAO.findByTopiaId(roleId);
                securityUserDAO.delete(user);
                transaction.commitTransaction();
                transaction.closeContext();
            }
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't delete user", ex);
            }
        }

        return SUCCESS;
    }

    @Override
    public void validate() {
        if (StringUtils.isNotBlank(password)) {
            if (!password.equals(confirm)) {
                addActionError(_("Les mots de passes ne sont pas identiques !"));
            }
        }
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();

        try {
            TopiaContext transaction = rootContext.beginTransaction();
            securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
            
            SecurityUser user = getUser();
            if (StringUtils.isNotBlank(password)) {
                String md5Password = StringUtil.encodeMD5(password);
                user.setPassword(md5Password);
            }
            if (user.getTopiaId() == null) {
                securityUserDAO.create(user);
            } else {
                securityUserDAO.update(user);
            }
            transaction.commitTransaction();
            transaction.closeContext();
        } catch (Exception ex) {
            addActionError(ex.getMessage());
            result = input();
        }
        return result;
    }
}
