/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.templates.TopiaTagValues;
import org.nuiton.topia.templates.TopiaTemplateHelper;

public class EntityEnumTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityEnumTransformer.class);
    protected TopiaTemplateHelper templateHelper;
    protected TopiaTagValues topiaTagValues;

    public void transformFromModel(ObjectModel input) {
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper((ObjectModel)this.model);
        }
        if (this.topiaTagValues == null) {
            this.topiaTagValues = this.templateHelper.getTopiaTagValues();
        }
        String packageName = this.templateHelper.getApplicationContextPackage(this, (ObjectModel)this.model);
        String entityEnumName = this.templateHelper.getEntityEnumName((ObjectModel)this.model);
        boolean generateOperator = this.topiaTagValues.getGenerateOperatorForDAOHelperTagValue((ObjectModel)this.model);
        this.generateEntityEnum(packageName, entityEnumName, generateOperator);
    }

    protected void generateEntityEnum(String packageName, String entityEnumName, boolean generateOperator) {
        List<ObjectModelClass> classes = this.templateHelper.getEntityClasses((ObjectModel)this.model, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will generate standalone " + entityEnumName + " in package " + packageName));
        }
        ObjectModelEnumeration entityEnum = this.createEnumeration(entityEnumName, packageName);
        this.addImport((ObjectModelClassifier)entityEnum, TopiaEntity.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)entityEnum, EntityOperatorStore.class);
        }
        this.addImport((ObjectModelClassifier)entityEnum, Arrays.class);
        this.addImport((ObjectModelClassifier)entityEnum, ArrayUtils.class);
        this.addImport((ObjectModelClassifier)entityEnum, Modifier.class);
        this.createEntityEnum(entityEnum, entityEnumName, generateOperator, classes);
    }

    protected void createEntityEnum(ObjectModelEnumeration entityEnum, String entityEnumName, boolean generateOperator, List<ObjectModelClass> classes) {
        this.addInterface((ObjectModelClassifier)entityEnum, TopiaEntityEnum.class);
        this.addImport((ObjectModelClassifier)entityEnum, Array.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)entityEnum, EntityOperator.class);
        }
        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            boolean withNatural = false;
            boolean withNotNull = false;
            StringBuilder naturalIdsParams = new StringBuilder();
            StringBuilder notNullParams = new StringBuilder();
            Set<ObjectModelAttribute> naturalIdsAttributes = this.templateHelper.getNaturalIdAttributes(clazz);
            for (ObjectModelAttribute attribute : naturalIdsAttributes) {
                withNatural = true;
                naturalIdsParams.append(", \"").append(attribute.getName()).append("\"");
            }
            Set<ObjectModelAttribute> notNullIdsAttributes = this.templateHelper.getNotNullAttributes(clazz);
            for (ObjectModelAttribute attribute : notNullIdsAttributes) {
                withNotNull = true;
                notNullParams.append(", \"").append(attribute.getName()).append("\"");
            }
            StringBuilder params = new StringBuilder(clazzName + ".class");
            if (withNotNull) {
                params.append(", new String[]{" + notNullParams.substring(2) + "}");
            } else {
                params.append(", ArrayUtils.EMPTY_STRING_ARRAY");
            }
            if (withNatural) {
                params.append(", ").append(naturalIdsParams.substring(2));
            }
            this.addLiteral(entityEnum, clazzName + '(' + params.toString() + ')');
            this.addImport((ObjectModelClassifier)entityEnum, clazz);
        }
        ObjectModelAttributeImpl attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "contract", "Class<? extends TopiaEntity>");
        attr.setDocumentation("The contract of the entity.");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementationFQN", "String");
        attr.setDocumentation("The fully qualified name of the implementation of the entity.");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementation", "Class<? extends TopiaEntity>");
        attr.setDocumentation("The implementation class of the entity (will be lazy computed at runtime).");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "naturalIds", "String[]");
        attr.setDocumentation("The array of property involved in the natural key of the entity.");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "notNulls", "String[]");
        attr.setDocumentation("The array of not null properties of the entity.");
        ObjectModelOperation op = this.addConstructor(entityEnum, (ObjectModelModifier)ObjectModelJavaModifier.PACKAGE);
        this.addParameter(op, "Class<? extends TopiaEntity>", "contract");
        this.addParameter(op, "String[]", "notNulls");
        this.addParameter(op, "String ...", "naturalIds");
        this.setOperationBody(op, "\n        this.contract = contract;\n        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);\n        this.naturalIds = naturalIds;\n        implementationFQN = contract.getName() + \"Impl\";\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContract", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return contract;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getNaturalIds", "String[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return naturalIds;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "isUseNaturalIds", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return naturalIds.length > 0;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getNotNulls", "String[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return notNulls;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "isUseNotNulls", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return notNulls.length > 0;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationFQN", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return implementationFQN;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "setImplementationFQN", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "String", "implementationFQN");
        if (generateOperator) {
            this.setOperationBody(op, "\n        this.implementationFQN = implementationFQN;\n        implementation = null;\n        // reinit the operators store\n        EntityOperatorStore.clear();\n    ");
        } else {
            this.setOperationBody(op, "\n        this.implementationFQN = implementationFQN;\n        this.implementation = null;\n    ");
        }
        op = this.addOperation((ObjectModelClassifier)entityEnum, "accept", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "Class<? extends TopiaEntity>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = valueOf(klass);\n" + "        boolean result = constant.getContract() == contract;\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementation", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.addImport((ObjectModelClassifier)entityEnum, TopiaException.class);
        this.setOperationBody(op, "\n        if (implementation == null) {\n            try {\n                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n            } catch (ClassNotFoundException e) {\n                throw new TopiaException(\"could not find class \" + implementationFQN, e);\n            }\n        }\n        return implementation;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "TopiaEntity", "entity");
        this.setOperationBody(op, "\n        return valueOf(entity.getClass());\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "final Class<?>", "klass");
        this.addImport((ObjectModelClassifier)entityEnum, Sets.class);
        this.addImport((ObjectModelClassifier)entityEnum, Set.class);
        this.addImport((ObjectModelClassifier)entityEnum, List.class);
        this.addImport((ObjectModelClassifier)entityEnum, ArrayList.class);
        this.addImport((ObjectModelClassifier)entityEnum, Predicate.class);
        this.addImport((ObjectModelClassifier)entityEnum, Iterables.class);
        this.addImport((ObjectModelClassifier)entityEnum, Iterable.class);
        this.addImport((ObjectModelClassifier)entityEnum, TopiaEntityHelper.class);
        this.setOperationBody(op, "\n        if (klass.isInterface()) {\n            return valueOf(klass.getSimpleName());\n        }\n\n        Class<?> contractClass = TopiaEntityHelper.getContractClass(" + entityEnumName + ".values(), (Class) klass);\n" + "\n" + "        if (contractClass != null) {\n" + "\n" + "            return valueOf(contractClass.getSimpleName());\n" + "        }\n" + "\n" + "        throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString(" + entityEnumName + ".values()));\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContracts", entityEnumName + "[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] result = values();\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContractClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = valueOf(klass);\n" + "        Class<T> result = (Class<T>) constant.getContract();\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContractClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getContract();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = valueOf(klass);\n" + "        Class<T> result = (Class<T>) constant.getImplementation();\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getImplementation();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationClassesAsString", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        StringBuilder buffer = new StringBuilder();\n        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n            buffer.append(',').append(aClass.getName());\n        }\n        String result = buffer.substring(1);\n        return result;\n    ");
        if (generateOperator) {
            op = this.addOperation((ObjectModelClassifier)entityEnum, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
            this.addParameter(op, "Class<T>", "klass");
            this.setOperationBody(op, "\n        " + entityEnumName + " constant = valueOf(klass);\n" + "        EntityOperator<T> result = EntityOperatorStore.getOperator(constant);\n" + "        return result;\n" + "    ");
        }
    }
}

